/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.stream.Source;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.wsdl.contribution.PortSymbol;
import org.fabric3.wsdl.contribution.PortTypeSymbol;
import org.fabric3.wsdl.contribution.WsdlResourceProcessorExtension;
import org.fabric3.wsdl.contribution.WsdlServiceContractSymbol;
import org.fabric3.wsdl.contribution.WsdlSymbol;
import org.fabric3.wsdl.contribution.impl.CallbackContractLoadError;
import org.fabric3.wsdl.contribution.impl.InvalidSchemaLocation;
import org.fabric3.wsdl.contribution.impl.InvalidWsdl;
import org.fabric3.wsdl.contribution.impl.PortTypeNotFound;
import org.fabric3.wsdl.contribution.impl.SourceWsdlLocator;
import org.fabric3.wsdl.factory.Wsdl4JFactory;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.fabric3.wsdl.processor.WsdlContractProcessor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WsdlResourceProcessor
implements ResourceProcessor {
    private static final QName SCHEMA_NAME = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final QName IMPORT_NAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName SCHEMA_LOCATION = new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
    private static final QName DEFINITIONS = new QName("http://schemas.xmlsoap.org/wsdl", "definitions");
    private static final QName CALLBACK_ATTRIBUTE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private static final String MIME_TYPE = "text/wsdl+xml";
    private ProcessorRegistry registry;
    private WsdlContractProcessor processor;
    private MetaDataStore store;
    private Wsdl4JFactory factory;
    private DocumentBuilderFactory documentBuilderFactory;
    private List<WsdlResourceProcessorExtension> extensions = new ArrayList<WsdlResourceProcessorExtension>();

    public WsdlResourceProcessor(@Reference ProcessorRegistry registry, @Reference WsdlContractProcessor processor, @Reference MetaDataStore store, @Reference Wsdl4JFactory factory) {
        this.registry = registry;
        this.processor = processor;
        this.store = store;
        this.factory = factory;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    @Reference(required=false)
    public void setExtensions(List<WsdlResourceProcessorExtension> extensions) {
        this.extensions = extensions;
    }

    @Init
    public void init() {
        this.registry.register((ResourceProcessor)this);
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    public QName getType() {
        return DEFINITIONS;
    }

    public void index(Contribution contribution, Source source, IntrospectionContext context) throws InstallException {
        InputStream stream = null;
        try {
            stream = source.openStream();
            Resource resource = new Resource(source, MIME_TYPE);
            this.parse(resource, context);
            contribution.addResource(resource);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
        for (ResourceElement element : resource.getResourceElements()) {
            ResourceElement resolved;
            WsdlServiceContract contract;
            PortType portType;
            QName callbackPortType;
            if (!(element.getSymbol() instanceof WsdlServiceContractSymbol) || (callbackPortType = (QName)(portType = (contract = (WsdlServiceContract)((Object)element.getValue())).getPortType()).getExtensionAttribute(CALLBACK_ATTRIBUTE)) == null) continue;
            WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(callbackPortType);
            URI contributionUri = context.getContributionUri();
            try {
                resolved = this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)symbol, context);
            }
            catch (StoreException e) {
                CallbackContractLoadError error = new CallbackContractLoadError("Error resolving callback port type:" + callbackPortType, e);
                context.addError((ValidationFailure)error);
                continue;
            }
            if (resolved == null) {
                PortTypeNotFound error = new PortTypeNotFound("Callback port type not found: " + callbackPortType);
                context.addError((ValidationFailure)error);
                continue;
            }
            WsdlServiceContract callbackContract = (WsdlServiceContract)((Object)resolved.getValue());
            contract.setCallbackContract(callbackContract);
        }
        resource.setProcessed(true);
    }

    private void parse(Resource resource, IntrospectionContext context) throws InstallException {
        QName name;
        Source source = resource.getSource();
        Definition definition = this.parseWsdl(source, context);
        QName wsdlQName = definition.getQName();
        WsdlSymbol wsdlSymbol = new WsdlSymbol(wsdlQName);
        ResourceElement wsdlElement = new ResourceElement((Symbol)wsdlSymbol, (Object)definition);
        resource.addResourceElement(wsdlElement);
        Map services = definition.getServices();
        for (Service service : services.values()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                name = new QName(definition.getTargetNamespace(), port.getName());
                PortSymbol portSymbol = new PortSymbol(name);
                ResourceElement portElement = new ResourceElement((Symbol)portSymbol, (Object)port);
                resource.addResourceElement(portElement);
            }
        }
        for (Object object : definition.getPortTypes().values()) {
            PortType portType = (PortType)object;
            QName name2 = portType.getQName();
            PortTypeSymbol symbol = new PortTypeSymbol(name2);
            ResourceElement element = new ResourceElement((Symbol)symbol, (Object)portType);
            resource.addResourceElement(element);
        }
        XmlSchemaCollection schemaCollection = this.parseSchema(definition, context);
        for (Object object : definition.getPortTypes().values()) {
            PortType portType = (PortType)object;
            WsdlServiceContract contract = this.processor.introspect(portType, wsdlQName, schemaCollection, context);
            name = portType.getQName();
            WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(name);
            ResourceElement element = new ResourceElement((Symbol)symbol, (Object)contract);
            resource.addResourceElement(element);
        }
        for (WsdlResourceProcessorExtension extension : this.extensions) {
            extension.process(resource, definition);
        }
    }

    private Definition parseWsdl(Source source, IntrospectionContext context) throws InstallException {
        SourceWsdlLocator locator = new SourceWsdlLocator(source, context);
        try {
            WSDLReader reader = this.factory.newReader();
            Definition definition = reader.readWSDL((WSDLLocator)locator);
            if (!definition.getNamespaces().values().contains("http://schemas.xmlsoap.org/wsdl/soap/")) {
                definition.addNamespace("soap11", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
            this.parseSchemaLocation(definition, context);
            Definition definition2 = definition;
            return definition2;
        }
        catch (WSDLException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            locator.close();
        }
    }

    private void parseSchemaLocation(Definition definition, IntrospectionContext context) throws InstallException {
        QName schemaLocation = (QName)definition.getExtensionAttribute(SCHEMA_LOCATION);
        if (schemaLocation == null) {
            return;
        }
        String trimmed = schemaLocation.getLocalPart().replaceAll("\\s{2,}", " ");
        String[] locationValue = trimmed.split(" ");
        int len = locationValue.length;
        if (len == 1) {
            this.populateSchemaTypes(definition, "", locationValue[0]);
        } else if (len > 1) {
            if (len % 2 != 0) {
                InvalidSchemaLocation error = new InvalidSchemaLocation("Invalid schemaLocation value: " + schemaLocation.getLocalPart());
                context.addError((ValidationFailure)error);
                return;
            }
            for (int i = 0; i < locationValue.length - 1; ++i) {
                String namespace = locationValue[i];
                String location = locationValue[i + 1];
                this.populateSchemaTypes(definition, namespace, location);
            }
        }
    }

    private void populateSchemaTypes(Definition definition, String targetNamespace, String schemaLocation) throws InstallException {
        Document document;
        Schema schema;
        Types types = definition.createTypes();
        try {
            schema = (Schema)definition.getExtensionRegistry().createExtension(Types.class, SCHEMA_NAME);
        }
        catch (WSDLException e) {
            throw new InstallException((Throwable)e);
        }
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InstallException((Throwable)e);
        }
        Element schemaElement = document.createElementNS(SCHEMA_NAME.getNamespaceURI(), "xsd:schema");
        schema.setElement(schemaElement);
        Element importElement = document.createElementNS(IMPORT_NAME.getNamespaceURI(), "xsd:import");
        importElement.setAttribute("namespace", targetNamespace);
        importElement.setAttribute("schemaLocation", schemaLocation);
        schemaElement.appendChild(importElement);
        types.addExtensibilityElement((ExtensibilityElement)schema);
        definition.setTypes(types);
    }

    private XmlSchemaCollection parseSchema(Definition definition, IntrospectionContext context) {
        XmlSchemaCollection collection = new XmlSchemaCollection();
        try {
            Types types = definition.getTypes();
            if (types == null) {
                return collection;
            }
            for (Object obj : types.getExtensibilityElements()) {
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                Element element = schema.getElement();
                collection.setBaseUri(schema.getDocumentBaseURI());
                String syntheticId = UUID.randomUUID().toString();
                collection.read(element, syntheticId);
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof XmlSchemaException)) {
                throw e;
            }
            InvalidWsdl error = new InvalidWsdl("Error parsing Schema", e.getCause());
            context.addError((ValidationFailure)error);
        }
        return collection;
    }
}

