/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.loader;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.IncompatibleContracts;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.wsdl.contribution.WsdlServiceContractSymbol;
import org.fabric3.wsdl.contribution.impl.PortTypeNotFound;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class InterfaceWsdlLoader
implements TypeLoader<WsdlServiceContract> {
    private MetaDataStore store;
    private ContractMatcher matcher;
    private LoaderHelper helper;

    public InterfaceWsdlLoader(@Reference MetaDataStore store, @Reference ContractMatcher matcher, @Reference LoaderHelper helper) {
        this.store = store;
        this.matcher = matcher;
        this.helper = helper;
    }

    public WsdlServiceContract load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        WsdlServiceContract wsdlContract = this.processInterface(reader, context);
        this.processCallbackInterface(reader, wsdlContract, context);
        this.helper.loadPolicySetsAndIntents((PolicyAware)wsdlContract, reader, context);
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        return wsdlContract;
    }

    private WsdlServiceContract processInterface(XMLStreamReader reader, IntrospectionContext context) {
        String interfaze = reader.getAttributeValue(null, "interface");
        if (interfaze == null) {
            MissingAttribute failure = new MissingAttribute("Interface attribute is required", reader);
            context.addError((ValidationFailure)failure);
            return new WsdlServiceContract(null, null);
        }
        QName portTypeName = this.parseQName(interfaze, reader, context);
        if (portTypeName == null) {
            return new WsdlServiceContract(null, null);
        }
        return this.resolveContract(portTypeName, reader, context);
    }

    private void processCallbackInterface(XMLStreamReader reader, WsdlServiceContract wsdlContract, IntrospectionContext context) {
        String callbackInterfaze = reader.getAttributeValue(null, "callbackInterface");
        if (callbackInterfaze != null) {
            MatchResult result;
            QName callbackName = this.parseQName(callbackInterfaze, reader, context);
            if (callbackName == null) {
                return;
            }
            WsdlServiceContract callbackContract = this.resolveContract(callbackName, reader, context);
            ServiceContract originalContract = wsdlContract.getCallbackContract();
            if (originalContract != null && !(result = this.matcher.isAssignableFrom((ServiceContract)callbackContract, originalContract, true)).isAssignable()) {
                IncompatibleContracts error = new IncompatibleContracts("The callback contract specified on interface.wsdl is not compatible with the one specified in the WSDL portType: " + result.getError(), reader);
                context.addError((ValidationFailure)error);
            }
            wsdlContract.setCallbackContract(callbackContract);
        }
    }

    QName parseQName(String portType, XMLStreamReader reader, IntrospectionContext context) {
        try {
            URI uri = new URI(portType);
            String namespace = UriHelper.getDefragmentedNameAsString((URI)uri);
            String localExpression = uri.getFragment();
            if (localExpression == null || !localExpression.toLowerCase().startsWith("wsdl.porttype(") || !localExpression.endsWith(")")) {
                InvalidValue error = new InvalidValue("A port type expression must be specified of the form <namespace>#wsdl.portType(portType): " + portType, reader);
                context.addError((ValidationFailure)error);
                return null;
            }
            String localPart = localExpression.substring(14, localExpression.length() - 1);
            return new QName(namespace, localPart);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid port type identifier: " + portType, reader, (Throwable)e);
            context.addError((ValidationFailure)error);
            return null;
        }
    }

    private WsdlServiceContract resolveContract(QName portTypeName, XMLStreamReader reader, IntrospectionContext context) {
        ResourceElement element;
        WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(portTypeName);
        URI contributionUri = context.getContributionUri();
        try {
            element = this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)symbol, context);
        }
        catch (StoreException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, reader);
            context.addError((ValidationFailure)failure);
            return new WsdlServiceContract(null, null);
        }
        if (element == null) {
            PortTypeNotFound error = new PortTypeNotFound("Port type not found: " + portTypeName);
            context.addError((ValidationFailure)error);
            return new WsdlServiceContract(null, null);
        }
        WsdlServiceContract contract = (WsdlServiceContract)((Object)element.getValue());
        return contract.copy();
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("interface".equals(name) || "callbackInterface".equals(name) || "remotable".equals(name) || "requires".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
        this.validateRemotable(reader, context);
    }

    private void validateRemotable(XMLStreamReader reader, IntrospectionContext context) {
        boolean remotable;
        String remotableAttr = reader.getAttributeValue(null, "remotable");
        if (remotableAttr != null && !(remotable = Boolean.parseBoolean(remotableAttr))) {
            InvalidValue error = new InvalidValue("WSDL interfaces cannot set remotable to false", reader);
            context.addError((ValidationFailure)error);
        }
    }
}

