/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.contribution.scanner.impl.ScannerMonitor;
import org.fabric3.contribution.scanner.spi.FileSystemResource;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactoryRegistry;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.FileContributionSource;
import org.fabric3.host.contribution.ValidationException;
import org.fabric3.host.domain.AssemblyException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.VoidService;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.ExtensionsInitialized;
import org.fabric3.spi.event.Fabric3Event;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.RuntimeStart;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=VoidService.class)
@EagerInit
public class ContributionDirectoryScanner
implements Runnable,
Fabric3EventListener {
    private final Map<String, FileSystemResource> cache = new HashMap<String, FileSystemResource>();
    private final Map<String, FileSystemResource> errorCache = new HashMap<String, FileSystemResource>();
    private final ContributionService contributionService;
    private final EventService eventService;
    private final ScannerMonitor monitor;
    private final Domain domain;
    private Map<String, URI> processed = new HashMap<String, URI>();
    private Set<File> ignored = new HashSet<File>();
    private FileSystemResourceFactoryRegistry registry;
    private File path;
    private long delay = 2000L;
    private ScheduledExecutorService executor;

    public ContributionDirectoryScanner(@Reference FileSystemResourceFactoryRegistry registry, @Reference ContributionService contributionService, @Reference(name="assembly") Domain domain, @Reference EventService eventService, @Reference HostInfo hostInfo, @Monitor ScannerMonitor monitor) {
        this.registry = registry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.eventService = eventService;
        this.path = hostInfo.getDeployDirectory();
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setPath(String dir) {
        this.path = new File(dir);
    }

    @Property(required=false)
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Init
    public void init() {
        this.eventService.subscribe(ExtensionsInitialized.class, (Fabric3EventListener)this);
        this.eventService.subscribe(RuntimeStart.class, (Fabric3EventListener)this);
    }

    @Destroy
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void onEvent(Fabric3Event event) {
        if (event instanceof ExtensionsInitialized) {
            File[] files = this.path.listFiles();
            this.recover(files);
        } else if (event instanceof RuntimeStart) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleWithFixedDelay(this, 10L, this.delay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void run() {
        if (!this.path.isDirectory()) {
            return;
        }
        try {
            File[] files = this.path.listFiles();
            this.processRemovals(files);
            this.processFiles(files);
            this.processIgnored();
        }
        catch (RuntimeException e) {
            this.monitor.error(e);
        }
        catch (Error e) {
            this.monitor.error(e);
            throw e;
        }
    }

    private synchronized void recover(File[] files) {
        try {
            ArrayList<File> contributions = new ArrayList<File>();
            for (File file : files) {
                String name = file.getName();
                FileSystemResource resource = null;
                FileSystemResource cached = this.errorCache.get(name);
                if (cached != null) {
                    resource = this.registry.createResource(file);
                    assert (resource != null);
                    resource.reset();
                    if (Arrays.equals(cached.getChecksum(), resource.getChecksum())) continue;
                    this.errorCache.remove(name);
                }
                if ((cached = this.cache.get(name)) != null) continue;
                if (resource == null) {
                    resource = this.registry.createResource(file);
                }
                if (resource == null) continue;
                resource.reset();
                this.cache.put(name, resource);
                contributions.add(file);
            }
            this.processAdditions(contributions, true);
        }
        catch (IOException e) {
            this.monitor.error(e);
        }
    }

    private synchronized void processFiles(File[] files) {
        boolean wait = false;
        for (File file : files) {
            try {
                String name = file.getName();
                FileSystemResource resource = null;
                FileSystemResource cached = this.errorCache.get(name);
                if (cached != null) {
                    resource = this.registry.createResource(file);
                    assert (resource != null);
                    resource.reset();
                    if (Arrays.equals(cached.getChecksum(), resource.getChecksum())) continue;
                    this.errorCache.remove(name);
                }
                if ((cached = this.cache.get(name)) == null) {
                    if (resource == null) {
                        resource = this.registry.createResource(file);
                    }
                    if (resource == null) {
                        if (!(name.startsWith(".") || name.endsWith(".txt") || this.ignored.contains(file))) {
                            this.monitor.ignored(name);
                        }
                        this.ignored.add(file);
                        continue;
                    }
                    resource.reset();
                    this.cache.put(name, resource);
                    wait = true;
                    continue;
                }
                if (!cached.isChanged()) continue;
                wait = true;
            }
            catch (IOException e) {
                this.monitor.error(e);
            }
        }
        if (!wait) {
            this.sortAndProcessChanges(files);
        }
    }

    private void sortAndProcessChanges(File[] files) {
        try {
            ArrayList<File> updates = new ArrayList<File>();
            ArrayList<File> additions = new ArrayList<File>();
            for (File file : files) {
                String name = file.getName();
                boolean isProcessed = this.processed.containsKey(name);
                boolean isError = this.errorCache.containsKey(name);
                if (!isError && isProcessed && !this.ignored.contains(file)) {
                    updates.add(file);
                    continue;
                }
                if (isError || isProcessed || this.ignored.contains(file)) continue;
                additions.add(file);
            }
            this.processUpdates(updates);
            this.processAdditions(additions, false);
        }
        catch (IOException e) {
            this.monitor.error(e);
        }
        catch (DeploymentException e) {
            this.monitor.error(e);
        }
    }

    private synchronized void processUpdates(List<File> files) throws IOException, DeploymentException {
        for (File file : files) {
            long previousTimestamp;
            String name = file.getName();
            URI artifactUri = this.processed.get(name);
            URL location = file.toURI().normalize().toURL();
            FileSystemResource cached = this.cache.remove(name);
            long timestamp = file.lastModified();
            if (timestamp <= (previousTimestamp = this.contributionService.getContributionTimestamp(artifactUri))) continue;
            try {
                FileContributionSource source = new FileContributionSource(artifactUri, location, timestamp, false);
                List deployables = this.contributionService.getDeployedComposites(artifactUri);
                ListIterator iter = deployables.listIterator(deployables.size());
                while (iter.hasPrevious()) {
                    QName deployable = (QName)iter.previous();
                    this.domain.undeploy(deployable);
                }
                this.contributionService.remove(artifactUri);
                this.contributionService.contribute((ContributionSource)source);
            }
            catch (ContributionException e) {
                this.errorCache.put(name, cached);
                this.monitor.error(e);
            }
            this.monitor.updated(artifactUri.toString());
        }
    }

    private synchronized void processAdditions(List<File> files, boolean recover) throws IOException {
        ArrayList<FileContributionSource> sources = new ArrayList<FileContributionSource>();
        ArrayList<FileSystemResource> addedResources = new ArrayList<FileSystemResource>();
        for (File file : files) {
            String name = file.getName();
            FileSystemResource cached = this.cache.remove(name);
            addedResources.add(cached);
            URL location = file.toURI().normalize().toURL();
            long timestamp = file.lastModified();
            try {
                FileContributionSource source = new FileContributionSource(URI.create(name), location, timestamp, false);
                sources.add(source);
            }
            catch (NoClassDefFoundError e) {
                this.errorCache.put(name, cached);
                this.monitor.error(e);
            }
        }
        if (!sources.isEmpty()) {
            try {
                List addedUris = this.contributionService.contribute(sources);
                if (!recover) {
                    this.domain.include(addedUris);
                }
                for (URI uri : addedUris) {
                    String name = uri.toString();
                    this.processed.put(name, uri);
                    this.monitor.processed(name);
                }
            }
            catch (ValidationException e) {
                this.monitor.contributionErrors(e.getMessage());
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
            }
            catch (AssemblyException e) {
                this.monitor.deploymentErrors(e.getMessage());
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
            }
            catch (ContributionException e) {
                this.monitor.error(e);
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
            }
            catch (DeploymentException e) {
                this.monitor.error(e);
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
            }
            catch (NoClassDefFoundError e) {
                this.monitor.error(e);
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
            }
            catch (Error e) {
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
                throw e;
            }
            catch (RuntimeException e) {
                for (FileSystemResource cached : addedResources) {
                    this.errorCache.put(cached.getName(), cached);
                }
                throw e;
            }
        }
    }

    private synchronized void processRemovals(File[] files) {
        HashMap<String, File> index = new HashMap<String, File>(files.length);
        for (File file : files) {
            index.put(file.getName(), file);
        }
        ArrayList<String> removed = new ArrayList<String>();
        for (Map.Entry<String, URI> entry : this.processed.entrySet()) {
            String filename = entry.getKey();
            URI uri = entry.getValue();
            if (index.get(filename) != null) continue;
            try {
                if (this.contributionService.exists(uri)) {
                    List deployables = this.contributionService.getDeployedComposites(uri);
                    ListIterator iter = deployables.listIterator(deployables.size());
                    while (iter.hasPrevious()) {
                        QName deployable = (QName)iter.previous();
                        this.domain.undeploy(deployable);
                    }
                    this.contributionService.uninstall(uri);
                    this.contributionService.remove(uri);
                }
                removed.add(filename);
                this.monitor.removed(filename);
            }
            catch (ContributionException e) {
                this.monitor.removalError(filename, e);
            }
            catch (DeploymentException e) {
                this.monitor.removalError(filename, e);
            }
        }
        for (String removedName : removed) {
            this.processed.remove(removedName);
        }
    }

    private synchronized void processIgnored() {
        Iterator<File> iter = this.ignored.iterator();
        while (iter.hasNext()) {
            File file = iter.next();
            if (file.exists()) continue;
            iter.remove();
        }
    }
}

