/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.contribution.scanner.spi.AbstractResource;
import org.fabric3.contribution.scanner.spi.FileSystemResource;

public class DirectoryResource
extends AbstractResource {
    private final File root;
    private List<FileSystemResource> resources;

    public DirectoryResource(File root) {
        this.root = root;
        this.resources = new ArrayList<FileSystemResource>();
    }

    public String getName() {
        return this.root.getName();
    }

    public URL getLocation() {
        try {
            return this.root.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getTimestamp() {
        return this.root.lastModified();
    }

    public void addResource(FileSystemResource resource) {
        this.resources.add(resource);
    }

    public void reset() throws IOException {
        for (FileSystemResource resource : this.resources) {
            resource.reset();
        }
        this.checksumValue = this.checksum();
    }

    protected byte[] checksum() {
        try {
            MessageDigest checksum = MessageDigest.getInstance("MD5");
            for (FileSystemResource resource : this.resources) {
                checksum.update(resource.getChecksum());
            }
            return checksum.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

