/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fabric3.contribution.scanner.spi.FileResource;
import org.fabric3.contribution.scanner.spi.FileSystemResource;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactory;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactoryRegistry;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class JarResourceFactory
implements FileSystemResourceFactory {
    public JarResourceFactory(@Reference FileSystemResourceFactoryRegistry registry) {
        registry.register(this);
    }

    public FileSystemResource createResource(File file) {
        if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file.getCanonicalPath());
            JarEntry entry = jarFile.getJarEntry("META-INF/sca-contribution.xml");
            if (entry == null) {
                FileSystemResource fileSystemResource = null;
                return fileSystemResource;
            }
        }
        catch (FileNotFoundException e) {
            FileSystemResource fileSystemResource = null;
            return fileSystemResource;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {}
        }
        return new FileResource(file);
    }
}

