/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.spi;

import java.io.IOException;
import org.fabric3.contribution.scanner.spi.FileSystemResource;

public abstract class AbstractResource
implements FileSystemResource {
    protected byte[] checksumValue;

    public boolean isChanged() throws IOException {
        byte[] newValue = this.checksum();
        if (this.checksumValue == null || this.checksumValue.length != newValue.length) {
            this.checksumValue = newValue;
            return true;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] == this.checksumValue[i]) continue;
            this.checksumValue = newValue;
            return true;
        }
        return false;
    }

    public byte[] getChecksum() {
        return this.checksumValue;
    }

    public void reset() throws IOException {
        this.checksumValue = this.checksum();
    }

    protected abstract byte[] checksum() throws IOException;
}

