/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.spi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fabric3.contribution.scanner.spi.AbstractResource;

public class FileResource
extends AbstractResource {
    private File file;

    public FileResource(File file) {
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public URL getLocation() {
        try {
            return this.file.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getTimestamp() {
        return this.file.lastModified();
    }

    public void reset() throws IOException {
        this.checksumValue = this.checksum();
    }

    protected byte[] checksum() throws IOException {
        BufferedInputStream is = null;
        try {
            int len;
            MessageDigest checksum = MessageDigest.getInstance("MD5");
            is = new BufferedInputStream(new FileInputStream(this.file));
            byte[] bytes = new byte[1024];
            while ((len = is.read(bytes)) >= 0) {
                checksum.update(bytes, 0, len);
            }
            byte[] byArray = checksum.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

