/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.component.OASISPojoComponentContext;
import org.fabric3.implementation.pojo.component.OASISPojoRequestContext;
import org.fabric3.implementation.pojo.component.PojoComponent;
import org.fabric3.implementation.pojo.component.PojoComponentContext;
import org.fabric3.implementation.pojo.component.PojoRequestContext;
import org.fabric3.implementation.pojo.injection.ConversationIDObjectFactory;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryProvider;
import org.fabric3.implementation.pojo.provision.PojoComponentDefinition;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.SingletonObjectFactory;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ComponentBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.physical.PhysicalPropertyDefinition;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.model.type.java.ManagementInfo;
import org.fabric3.spi.util.ParamTypes;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PojoComponentBuilder<PCD extends PojoComponentDefinition, C extends Component>
implements ComponentBuilder<PCD, C> {
    protected ClassLoaderRegistry classLoaderRegistry;
    protected IntrospectionHelper helper;
    private PropertyObjectFactoryBuilder propertyBuilder;
    private ManagementService managementService;

    protected PojoComponentBuilder(ClassLoaderRegistry registry, PropertyObjectFactoryBuilder propertyBuilder, ManagementService managementService, IntrospectionHelper helper) {
        this.classLoaderRegistry = registry;
        this.propertyBuilder = propertyBuilder;
        this.managementService = managementService;
        this.helper = helper;
    }

    protected void createPropertyFactories(PCD definition, InstanceFactoryProvider provider) throws BuilderException {
        List propertyDefinitions = definition.getPropertyDefinitions();
        TypeMapping typeMapping = new TypeMapping();
        this.helper.resolveTypeParameters(provider.getImplementationClass(), typeMapping);
        for (PhysicalPropertyDefinition propertyDefinition : propertyDefinitions) {
            String name = propertyDefinition.getName();
            Document value = propertyDefinition.getValue();
            Injectable source = new Injectable(InjectableType.PROPERTY, name);
            Type type = provider.getGenericType(source);
            DataType<?> dataType = this.getDataType(type, typeMapping);
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
            boolean many = propertyDefinition.isMany();
            ObjectFactory<?> objectFactory = this.propertyBuilder.createObjectFactory(name, dataType, value, many, classLoader);
            provider.setObjectFactory(source, objectFactory);
        }
    }

    protected void export(PojoComponentDefinition definition, ClassLoader classLoader, AtomicComponent component) throws BuilderException {
        if (definition.isManaged()) {
            ManagementInfo info = definition.getManagementInfo();
            ObjectFactory objectFactory = component.createObjectFactory();
            try {
                URI uri = definition.getComponentUri();
                this.managementService.export(uri, info, objectFactory, classLoader);
            }
            catch (ManagementException e) {
                throw new BuilderException((Throwable)e);
            }
        }
    }

    protected void dispose(PojoComponentDefinition definition) throws BuilderException {
        if (definition.isManaged()) {
            ManagementInfo info = definition.getManagementInfo();
            try {
                URI uri = definition.getComponentUri();
                this.managementService.remove(uri, info);
            }
            catch (ManagementException e) {
                throw new BuilderException((Throwable)e);
            }
        }
    }

    protected void buildContexts(PojoComponent component, InstanceFactoryProvider provider) {
        PojoRequestContext requestContext = new PojoRequestContext();
        SingletonObjectFactory requestObjectFactory = new SingletonObjectFactory((Object)requestContext);
        provider.setObjectFactory(Injectable.REQUEST_CONTEXT, (ObjectFactory<?>)requestObjectFactory);
        PojoComponentContext componentContext = new PojoComponentContext(component, requestContext);
        SingletonObjectFactory componentObjectFactory = new SingletonObjectFactory((Object)componentContext);
        provider.setObjectFactory(Injectable.COMPONENT_CONTEXT, (ObjectFactory<?>)componentObjectFactory);
        ConversationIDObjectFactory conversationIDObjectFactory = new ConversationIDObjectFactory();
        provider.setObjectFactory(Injectable.CONVERSATION_ID, conversationIDObjectFactory);
        OASISPojoRequestContext oasisRequestContext = new OASISPojoRequestContext();
        SingletonObjectFactory oasisRequestFactory = new SingletonObjectFactory((Object)oasisRequestContext);
        provider.setObjectFactory(Injectable.OASIS_REQUEST_CONTEXT, (ObjectFactory<?>)oasisRequestFactory);
        OASISPojoComponentContext oasisComponentContext = new OASISPojoComponentContext(component, oasisRequestContext);
        SingletonObjectFactory oasisComponentFactory = new SingletonObjectFactory((Object)oasisComponentContext);
        provider.setObjectFactory(Injectable.OASIS_COMPONENT_CONTEXT, (ObjectFactory<?>)oasisComponentFactory);
    }

    private DataType<?> getDataType(Type type, TypeMapping typeMapping) {
        if (type instanceof Class) {
            Class nonGenericType = (Class)type;
            if (nonGenericType.isPrimitive()) {
                nonGenericType = (Class)ParamTypes.PRIMITIVE_TO_OBJECT.get(nonGenericType);
            }
            return new JavaClass(nonGenericType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(type, typeMapping);
        return new JavaGenericType(info);
    }
}

