/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.builder.PropertyTransformException;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.SingletonObjectFactory;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.ParamTypes;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyObjectFactoryBuilderImpl
implements PropertyObjectFactoryBuilder {
    private TransformerRegistry transformerRegistry;

    public PropertyObjectFactoryBuilderImpl(@Reference TransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    public ObjectFactory<?> createObjectFactory(String name, DataType<?> dataType, Document value, boolean many, ClassLoader classLoader) throws BuilderException {
        Class physical = dataType.getPhysical();
        if (physical.isArray()) {
            return this.createArrayFactory(name, dataType, value, classLoader);
        }
        if (Map.class.equals((Object)physical)) {
            return this.createMapFactory(name, (JavaGenericType)dataType, value, classLoader);
        }
        if (List.class.equals((Object)physical)) {
            return this.createListFactory(name, (JavaGenericType)dataType, value, classLoader);
        }
        if (Set.class.equals((Object)physical)) {
            return this.createSetFactory(name, (JavaGenericType)dataType, value, classLoader);
        }
        if (LinkedList.class.equals((Object)physical)) {
            return this.createLinkedListFactory(name, (JavaGenericType)dataType, value, classLoader);
        }
        return this.createDefaultObjectFactory(name, dataType, value, classLoader);
    }

    private ObjectFactory<?> createDefaultObjectFactory(String name, DataType<?> dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            Class physical = dataType.getPhysical();
            ArrayList types = new ArrayList();
            types.add(physical);
            Transformer transformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, dataType, types);
            Element element = (Element)value.getDocumentElement().getFirstChild();
            Object instance = transformer.transform((Object)element, classLoader);
            return new SingletonObjectFactory(instance);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }

    private ObjectFactory<Map> createMapFactory(String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            List typeInfos = ((JavaTypeInfo)dataType.getLogical()).getParameterTypesInfos();
            if (typeInfos.size() < 2) {
                throw new PropertyTransformException("Map properties must have a key and value type");
            }
            Class keyType = ((JavaTypeInfo)typeInfos.get(0)).getRawType();
            ArrayList keyTypes = new ArrayList();
            keyTypes.add(keyType);
            Class valueType = ((JavaTypeInfo)((JavaTypeInfo)dataType.getLogical()).getParameterTypesInfos().get(1)).getRawType();
            ArrayList valueTypes = new ArrayList();
            valueTypes.add(valueType);
            Transformer keyTransformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(keyType), keyTypes);
            Transformer valueTransformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(valueType), valueTypes);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Element root = value.getDocumentElement();
            NodeList nodes = root.getFirstChild().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node entryNode = nodes.item(i);
                if (entryNode.getChildNodes().getLength() != 2) {
                    throw new PropertyTransformException("Invalid Map format: there must be a key and value node for property " + name);
                }
                Element keyNode = (Element)entryNode.getChildNodes().item(0);
                Element valNode = (Element)entryNode.getChildNodes().item(1);
                Object key = keyTransformer.transform((Object)keyNode, classLoader);
                Object val = valueTransformer.transform((Object)valNode, classLoader);
                map.put(key, val);
            }
            return new SingletonObjectFactory(map);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }

    private ObjectFactory<?> createArrayFactory(String name, DataType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            Class componentType;
            Class type = componentType = dataType.getPhysical().getComponentType();
            if (type.isPrimitive()) {
                type = (Class)ParamTypes.PRIMITIVE_TO_OBJECT.get(type);
            }
            ArrayList types = new ArrayList();
            types.add(type);
            Transformer transformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(type), types);
            Element root = value.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            Object array = Array.newInstance(componentType, nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i).getFirstChild();
                Object val = transformer.transform((Object)node, classLoader);
                Array.set(array, i, val);
            }
            return new SingletonObjectFactory(array);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }

    private <T> ObjectFactory<Collection<T>> createSetFactory(String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        return this.createCollectionFactory(new HashSet(), name, dataType, value, classLoader);
    }

    private <T> ObjectFactory<Collection<T>> createLinkedListFactory(String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        return this.createCollectionFactory(new LinkedList(), name, dataType, value, classLoader);
    }

    private <T> ObjectFactory<Collection<T>> createListFactory(String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        return this.createCollectionFactory(new ArrayList(), name, dataType, value, classLoader);
    }

    private <T> ObjectFactory<Collection<T>> createCollectionFactory(Collection<T> collection, String name, JavaGenericType dataType, Document value, ClassLoader classLoader) throws PropertyTransformException {
        try {
            List typeInfos = ((JavaTypeInfo)dataType.getLogical()).getParameterTypesInfos();
            if (typeInfos.size() < 1) {
                throw new PropertyTransformException("List properties must have a value type");
            }
            Class type = ((JavaTypeInfo)typeInfos.get(0)).getRawType();
            ArrayList types = new ArrayList();
            types.add(type);
            Transformer<T, ?> transformer = this.getTransformer(name, (DataType<?>)XSDConstants.PROPERTY_TYPE, (DataType<?>)new JavaClass(type), types);
            Element root = value.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i).getFirstChild();
                Object val = transformer.transform((Object)node, classLoader);
                collection.add(val);
            }
            return new SingletonObjectFactory(collection);
        }
        catch (TransformationException e) {
            throw new PropertyTransformException("Unable to transform property value: " + name, e);
        }
    }

    private <T> Transformer<T, ?> getTransformer(String name, DataType<?> sourceType, DataType<?> targetType, List<Class<?>> types) throws TransformationException, PropertyTransformException {
        Transformer transformer = this.transformerRegistry.getTransformer(sourceType, targetType, types, types);
        if (transformer == null) {
            throw new PropertyTransformException("No transformer for property " + name + " of type: " + targetType);
        }
        return transformer;
    }
}

