/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.wire.InvocationRuntimeException;
import org.osoa.sca.ConversationEndedException;

public class InvokerEventStreamHandler
implements EventStreamHandler {
    private Method operation;
    private AtomicComponent component;
    private ScopeContainer scopeContainer;
    private ClassLoader targetTCCLClassLoader;

    public InvokerEventStreamHandler(Method operation, AtomicComponent component, ScopeContainer scopeContainer, ClassLoader targetTCCLClassLoader) {
        this.operation = operation;
        this.component = component;
        this.scopeContainer = scopeContainer;
        this.targetTCCLClassLoader = targetTCCLClassLoader;
    }

    public void setNext(EventStreamHandler next) {
        throw new IllegalStateException("This handler must be the last one in the handler sequence");
    }

    public EventStreamHandler getNext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Object event) {
        InstanceWrapper wrapper;
        WorkContext workContext = new WorkContext();
        try {
            wrapper = this.scopeContainer.getWrapper(this.component, workContext);
        }
        catch (ConversationEndedException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstanceLifecycleException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        try {
            Object instance = wrapper.getInstance();
            this.invoke(event, workContext, instance);
        }
        finally {
            try {
                this.scopeContainer.returnWrapper(this.component, workContext, wrapper);
            }
            catch (InstanceDestructionException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(Object event, WorkContext workContext, Object instance) {
        block10: {
            WorkContext oldWorkContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
            try {
                if (this.targetTCCLClassLoader == null) {
                    this.operation.invoke(instance, (Object[])event);
                    break block10;
                }
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.targetTCCLClassLoader);
                    this.operation.invoke(instance, (Object[])event);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (InvocationTargetException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
            finally {
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
        }
    }
}

