/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.implementation.pojo.component.NonRenewableExpirationPolicy;
import org.fabric3.implementation.pojo.component.RenewableExpirationPolicy;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.ExpirationPolicy;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.ConversationContext;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationRuntimeException;
import org.osoa.sca.ConversationEndedException;

public class InvokerInterceptor
implements Interceptor {
    private Method operation;
    private AtomicComponent component;
    private ScopeContainer scopeContainer;
    private ClassLoader targetTCCLClassLoader;
    private boolean callback;
    private boolean endConversation;
    private boolean conversationScope;

    public InvokerInterceptor(Method operation, boolean callback, boolean endConversation, AtomicComponent component, ScopeContainer scopeContainer) {
        this.operation = operation;
        this.callback = callback;
        this.endConversation = endConversation;
        this.component = component;
        this.scopeContainer = scopeContainer;
        this.conversationScope = Scope.CONVERSATION.equals((Object)scopeContainer.getScope());
    }

    public InvokerInterceptor(Method operation, boolean callback, boolean endConversation, AtomicComponent component, ScopeContainer scopeContainer, ClassLoader targetTCCLClassLoader) {
        this.operation = operation;
        this.callback = callback;
        this.endConversation = endConversation;
        this.component = component;
        this.scopeContainer = scopeContainer;
        this.targetTCCLClassLoader = targetTCCLClassLoader;
        this.conversationScope = Scope.CONVERSATION.equals((Object)scopeContainer.getScope());
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last one in an target interceptor chain");
    }

    public Interceptor getNext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        InstanceWrapper wrapper;
        WorkContext workContext = msg.getWorkContext();
        try {
            this.startOrJoinContext(workContext);
            wrapper = this.scopeContainer.getWrapper(this.component, workContext);
        }
        catch (ConversationEndedException e) {
            msg.setBodyWithFault((Object)e);
            return msg;
        }
        catch (InstanceLifecycleException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        try {
            Object instance = wrapper.getInstance();
            Message message = this.invoke(msg, workContext, instance);
            return message;
        }
        finally {
            try {
                this.scopeContainer.returnWrapper(this.component, workContext, wrapper);
                if (this.conversationScope && this.endConversation) {
                    this.scopeContainer.stopContext(workContext);
                }
            }
            catch (ComponentException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message invoke(Message msg, WorkContext workContext, Object instance) {
        block11: {
            WorkContext oldWorkContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
            try {
                Object body = msg.getBody();
                if (this.targetTCCLClassLoader == null) {
                    msg.setBody(this.operation.invoke(instance, (Object[])body));
                    break block11;
                }
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.targetTCCLClassLoader);
                    msg.setBody(this.operation.invoke(instance, (Object[])body));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (InvocationTargetException e) {
                msg.setBodyWithFault((Object)e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
            finally {
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
        }
        return msg;
    }

    private void startOrJoinContext(WorkContext workContext) throws InvocationRuntimeException {
        if (this.callback || !this.conversationScope) {
            return;
        }
        CallFrame frame = workContext.peekCallFrame();
        if (frame == null) {
            return;
        }
        try {
            if (ConversationContext.NEW == frame.getConversationContext()) {
                if (this.component.getMaxAge() > 0L) {
                    NonRenewableExpirationPolicy policy = new NonRenewableExpirationPolicy(System.currentTimeMillis() + this.component.getMaxAge());
                    this.scopeContainer.startContext(workContext, (ExpirationPolicy)policy);
                } else if (this.component.getMaxIdleTime() > 0L) {
                    long expire = System.currentTimeMillis() + this.component.getMaxIdleTime();
                    RenewableExpirationPolicy policy = new RenewableExpirationPolicy(expire, this.component.getMaxIdleTime());
                    this.scopeContainer.startContext(workContext, (ExpirationPolicy)policy);
                } else {
                    this.scopeContainer.startContext(workContext);
                }
            } else if (ConversationContext.PROPAGATE == frame.getConversationContext()) {
                if (this.component.getMaxAge() > 0L) {
                    NonRenewableExpirationPolicy policy = new NonRenewableExpirationPolicy(System.currentTimeMillis() + this.component.getMaxAge());
                    this.scopeContainer.joinContext(workContext, (ExpirationPolicy)policy);
                } else if (this.component.getMaxIdleTime() > 0L) {
                    long expire = System.currentTimeMillis() + this.component.getMaxIdleTime();
                    RenewableExpirationPolicy policy = new RenewableExpirationPolicy(expire, this.component.getMaxIdleTime());
                    this.scopeContainer.joinContext(workContext, (ExpirationPolicy)policy);
                } else {
                    this.scopeContainer.joinContext(workContext);
                }
            }
        }
        catch (ComponentException e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
    }
}

