/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.implementation.pojo.injection.ComponentObjectFactory;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactory;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryProvider;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.model.type.java.Injectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PojoComponent
implements AtomicComponent {
    private URI uri;
    private InstanceFactoryProvider provider;
    private ScopeContainer scopeContainer;
    private QName deployable;
    private boolean eager;
    private long maxIdleTime;
    private long maxAge;
    private InstanceFactory instanceFactory;
    private URI classLoaderId;
    private MonitorLevel level = MonitorLevel.INFO;

    public PojoComponent(URI componentId, InstanceFactoryProvider provider, ScopeContainer scopeContainer, QName deployable, boolean eager, long maxIdleTime, long maxAge) {
        this.uri = componentId;
        this.provider = provider;
        this.scopeContainer = scopeContainer;
        this.deployable = deployable;
        this.eager = eager;
        this.maxIdleTime = maxIdleTime;
        this.maxAge = maxAge;
    }

    public void start() throws ComponentException {
        this.scopeContainer.register((AtomicComponent)this);
    }

    public void stop() throws ComponentException {
        this.instanceFactory = null;
        this.scopeContainer.unregister((AtomicComponent)this);
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public URI getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(URI classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public boolean isEagerInit() {
        return this.eager;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public InstanceWrapper createInstanceWrapper(WorkContext workContext) throws ObjectCreationException {
        return this.getInstanceFactory().newInstance(workContext);
    }

    public ObjectFactory<Object> createObjectFactory() {
        return new ComponentObjectFactory(this, this.scopeContainer);
    }

    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    public Class<?> getImplementationClass() {
        return this.provider.getImplementationClass();
    }

    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory) {
        this.setObjectFactory(injectable, objectFactory, null);
    }

    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory, Object key) {
        this.scopeContainer.updated((AtomicComponent)this, injectable.getName());
        this.provider.setObjectFactory(injectable, objectFactory, key);
        this.instanceFactory = null;
    }

    public void removeObjectFactory(Injectable injectable) {
        this.scopeContainer.removed((AtomicComponent)this, injectable.getName());
        this.provider.removeObjectFactory(injectable);
        this.instanceFactory = null;
    }

    public ObjectFactory<?> getObjectFactory(Injectable injectable) {
        return this.provider.getObjectFactory(injectable);
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private InstanceFactory getInstanceFactory() {
        if (this.instanceFactory == null) {
            this.instanceFactory = this.provider.createFactory();
        }
        return this.instanceFactory;
    }
}

