/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.generator;

import java.util.HashSet;
import java.util.Map;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.provision.InstanceFactoryDefinition;
import org.fabric3.implementation.pojo.provision.PojoComponentDefinition;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.physical.PhysicalPropertyDefinition;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.Signature;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationHelperImpl
implements GenerationHelper {
    @Override
    public void processInjectionSites(InjectingComponentType componentType, InstanceFactoryDefinition factoryDefinition) {
        Map mappings = componentType.getInjectionSites();
        Map<InjectionSite, Injectable> construction = factoryDefinition.getConstruction();
        Signature constructor = componentType.getConstructor();
        HashSet<Injectable> byConstruction = new HashSet<Injectable>(constructor.getParameterTypes().size());
        for (int i = 0; i < constructor.getParameterTypes().size(); ++i) {
            ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, i);
            Injectable attribute = (Injectable)mappings.get(site);
            construction.put((InjectionSite)site, attribute);
            byConstruction.add(attribute);
        }
        Map<InjectionSite, Injectable> postConstruction = factoryDefinition.getPostConstruction();
        Map<InjectionSite, Injectable> reinjection = factoryDefinition.getReinjectables();
        for (Map.Entry entry : mappings.entrySet()) {
            InjectionSite site = (InjectionSite)entry.getKey();
            if (site instanceof ConstructorInjectionSite) continue;
            Injectable attribute = (Injectable)entry.getValue();
            if (!byConstruction.contains(attribute)) {
                postConstruction.put(site, attribute);
            }
            reinjection.put(site, attribute);
        }
    }

    @Override
    public void processPropertyValues(LogicalComponent<?> component, PojoComponentDefinition physical) {
        for (LogicalProperty property : component.getAllProperties().values()) {
            Document document = property.getValue();
            if (document == null) continue;
            String name = property.getName();
            boolean many = property.isMany();
            PhysicalPropertyDefinition definition = new PhysicalPropertyDefinition(name, document, many);
            physical.setPropertyDefinition(definition);
        }
    }
}

