/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.implementation.pojo.builder.ChannelProxyService;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.implementation.pojo.proxy.ChannelConnectionObjectFactory;
import org.fabric3.implementation.pojo.proxy.JDKEventHandler;
import org.fabric3.implementation.pojo.proxy.NoMethodForEventStreamException;
import org.fabric3.implementation.pojo.proxy.OptimizedChannelConnectionObjectFactory;
import org.fabric3.implementation.pojo.proxy.OptimizedJDKEventHandler;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKChannelProxyService
implements ChannelProxyService {
    private ClassLoaderRegistry classLoaderRegistry;

    public JDKChannelProxyService(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public <T> ObjectFactory<T> createObjectFactory(Class<T> interfaze, ChannelConnection connection) throws ProxyCreationException {
        if (connection.getEventStreams().size() == 1) {
            return new OptimizedChannelConnectionObjectFactory<T>(interfaze, this, (EventStream)connection.getEventStreams().get(0));
        }
        Map<Method, EventStream> mappings = this.createInterfaceToStreamMapping(interfaze, connection);
        return new ChannelConnectionObjectFactory<T>(interfaze, this, mappings);
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, Map<Method, EventStream> mappings) throws ProxyCreationException {
        ClassLoader loader = interfaze.getClassLoader();
        JDKEventHandler handler = new JDKEventHandler(mappings);
        return interfaze.cast(Proxy.newProxyInstance(loader, new Class[]{interfaze}, (InvocationHandler)handler));
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, EventStream stream) throws ProxyCreationException {
        ClassLoader loader = interfaze.getClassLoader();
        OptimizedJDKEventHandler handler = new OptimizedJDKEventHandler(stream);
        return interfaze.cast(Proxy.newProxyInstance(loader, new Class[]{interfaze}, (InvocationHandler)handler));
    }

    private Map<Method, EventStream> createInterfaceToStreamMapping(Class<?> interfaze, ChannelConnection connection) throws ProxyCreationException {
        List streams = connection.getEventStreams();
        HashMap<Method, EventStream> mappings = new HashMap<Method, EventStream>(streams.size());
        for (EventStream stream : streams) {
            PhysicalEventStreamDefinition definition = stream.getDefinition();
            try {
                Method method = this.findMethod(interfaze, definition);
                mappings.put(method, stream);
            }
            catch (NoSuchMethodException e) {
                throw new NoMethodForEventStreamException(definition.getName());
            }
            catch (ClassNotFoundException e) {
                throw new ProxyCreationException(e);
            }
        }
        return mappings;
    }

    private Method findMethod(Class<?> clazz, PhysicalEventStreamDefinition definition) throws NoSuchMethodException, ClassNotFoundException {
        String name = definition.getName();
        List eventTypes = definition.getEventTypes();
        Class[] types = new Class[eventTypes.size()];
        for (int i = 0; i < eventTypes.size(); ++i) {
            types[i] = this.classLoaderRegistry.loadClass(clazz.getClassLoader(), (String)eventTypes.get(i));
        }
        return clazz.getMethod(name, types);
    }
}

