/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.ObjectCallbackException;

public class MethodEventInvoker
implements EventInvoker {
    private final Method method;

    public MethodEventInvoker(Method method) {
        assert (method != null);
        this.method = method;
        this.method.setAccessible(true);
    }

    public void invokeEvent(Object instance) throws ObjectCallbackException {
        try {
            this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            String name = this.method.toString();
            throw new ObjectCallbackException("Exception thrown by method: " + name, e.getCause());
        }
        catch (IllegalAccessException e) {
            String name = this.method.getName();
            throw new AssertionError((Object)("Method is not accessible: " + name));
        }
        catch (InvocationTargetException e) {
            String name = this.method.getName();
            throw new ObjectCallbackException("Exception thrown by callback method:" + name, e.getCause());
        }
    }
}

