/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.implementation.pojo.injection.MultiplicityObjectFactory;
import org.fabric3.spi.Injector;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjector
implements Injector<Object> {
    private final Method method;
    private ObjectFactory<?> objectFactory;

    public MethodInjector(Method method, ObjectFactory<?> objectFactory) {
        assert (method != null);
        assert (objectFactory != null);
        this.method = method;
        this.method.setAccessible(true);
        this.objectFactory = objectFactory;
    }

    public void inject(Object instance) throws ObjectCreationException {
        Object target;
        if (this.objectFactory == null) {
            target = null;
        } else {
            target = this.objectFactory.getInstance();
            if (target == null) {
                return;
            }
        }
        try {
            this.method.invoke(instance, target);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Method is not accessible:" + this.method));
        }
        catch (IllegalArgumentException e) {
            String id = this.method.toString();
            throw new ObjectCreationException("Exception thrown by setter: " + id, id, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String id = this.method.toString();
            throw new ObjectCreationException("Exception thrown by setter: " + id, id, (Throwable)e);
        }
    }

    public void setObjectFactory(ObjectFactory<?> objectFactory, Object key) {
        if (this.objectFactory instanceof MultiplicityObjectFactory) {
            ((MultiplicityObjectFactory)this.objectFactory).addObjectFactory(objectFactory, key);
        } else {
            this.objectFactory = objectFactory;
        }
    }

    public void clearObjectFactory() {
        if (this.objectFactory instanceof MultiplicityObjectFactory) {
            ((MultiplicityObjectFactory)this.objectFactory).clear();
        } else {
            this.objectFactory = null;
        }
    }
}

