/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import org.fabric3.implementation.pojo.instancefactory.InstanceFactory;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.ReflectiveInstanceWrapper;
import org.fabric3.spi.Injector;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.model.type.java.Injectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInstanceFactory
implements InstanceFactory {
    private final ObjectFactory<?> constructor;
    private Injectable[] injectables;
    private final Injector<Object>[] injectors;
    private final EventInvoker initInvoker;
    private final EventInvoker destroyInvoker;
    private final ClassLoader cl;
    private final boolean reinjectable;

    public ReflectiveInstanceFactory(ObjectFactory<?> constructor, Injectable[] injectables, Injector<Object>[] injectors, EventInvoker initInvoker, EventInvoker destroyInvoker, boolean reinjectable, ClassLoader cl) {
        this.constructor = constructor;
        this.injectables = injectables;
        this.injectors = injectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceWrapper newInstance(WorkContext workContext) throws ObjectCreationException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        WorkContext oldContext = WorkContextTunnel.setThreadWorkContext((WorkContext)workContext);
        try {
            Object instance = this.constructor.getInstance();
            if (this.injectors != null) {
                for (Injector<Object> injector : this.injectors) {
                    injector.inject(instance);
                }
            }
            ReflectiveInstanceWrapper reflectiveInstanceWrapper = new ReflectiveInstanceWrapper(instance, this.reinjectable, this.cl, this.initInvoker, this.destroyInvoker, this.injectables, this.injectors);
            return reflectiveInstanceWrapper;
        }
        finally {
            WorkContextTunnel.setThreadWorkContext((WorkContext)oldContext);
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

