/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryBuilder;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryBuilderException;
import org.fabric3.implementation.pojo.provision.InstanceFactoryDefinition;
import org.fabric3.implementation.pojo.reflection.ReflectiveInstanceFactoryProvider;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.Signature;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ReflectiveInstanceFactoryBuilder
implements InstanceFactoryBuilder {
    private ClassLoaderRegistry classLoaderRegistry;

    public ReflectiveInstanceFactoryBuilder(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public ReflectiveInstanceFactoryProvider build(InstanceFactoryDefinition definition, ClassLoader cl) throws InstanceFactoryBuilderException {
        try {
            String className = definition.getImplementationClass();
            Class implClass = this.classLoaderRegistry.loadClass(cl, className);
            Constructor ctr = this.getConstructor(implClass, definition.getConstructor());
            Map<InjectionSite, Injectable> injectionSites = definition.getConstruction();
            Injectable[] cdiSources = new Injectable[ctr.getParameterTypes().length];
            for (Map.Entry<InjectionSite, Injectable> entry : injectionSites.entrySet()) {
                InjectionSite site = entry.getKey();
                Injectable attribute = entry.getValue();
                ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
                cdiSources[constructorSite.getParam()] = attribute;
            }
            for (int i = 0; i < cdiSources.length; ++i) {
                if (cdiSources[i] != null) continue;
                String clazz = ctr.getName();
                throw new InstanceFactoryBuilderException("No injection value for constructor parameter " + i + " in class " + clazz, clazz);
            }
            Method initMethod = this.getMethod(implClass, definition.getInitMethod());
            Method destroyMethod = this.getMethod(implClass, definition.getDestroyMethod());
            Map<InjectionSite, Injectable> postConstruction = definition.getPostConstruction();
            List<Injectable> construction = Arrays.asList(cdiSources);
            boolean reinjectable = definition.isReinjectable();
            return new ReflectiveInstanceFactoryProvider(ctr, construction, postConstruction, initMethod, destroyMethod, reinjectable, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new InstanceFactoryBuilderException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InstanceFactoryBuilderException(ex);
        }
    }

    private Method getMethod(Class<?> implClass, Signature signature) throws NoSuchMethodException, ClassNotFoundException {
        return signature == null ? null : signature.getMethod(implClass);
    }

    private <T> Constructor<T> getConstructor(Class<T> implClass, Signature signature) throws ClassNotFoundException, NoSuchMethodException {
        Constructor ctr = signature.getConstructor(implClass);
        ctr.setAccessible(true);
        return ctr;
    }
}

