/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.implementation.pojo.injection.ArrayMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.injection.ListMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.injection.MapMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.injection.MultiplicityObjectFactory;
import org.fabric3.implementation.pojo.injection.SetMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactory;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryProvider;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.FieldInjector;
import org.fabric3.implementation.pojo.reflection.MethodEventInvoker;
import org.fabric3.implementation.pojo.reflection.MethodInjector;
import org.fabric3.implementation.pojo.reflection.ReflectiveInstanceFactory;
import org.fabric3.implementation.pojo.reflection.ReflectiveObjectFactory;
import org.fabric3.spi.Injector;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInstanceFactoryProvider
implements InstanceFactoryProvider {
    private static final ObjectFactory<?> NULL_FACTORY = new ObjectFactory<Object>(){

        public Object getInstance() {
            return null;
        }
    };
    private final Class<?> implementationClass;
    private final Constructor<?> constructor;
    private final List<Injectable> cdiSources;
    private final Map<InjectionSite, Injectable> postConstruction;
    private final EventInvoker initInvoker;
    private final EventInvoker destroyInvoker;
    private final Map<Injectable, ObjectFactory<?>> factories = new HashMap();
    private final ClassLoader cl;
    private final boolean reinjectable;

    public ReflectiveInstanceFactoryProvider(Constructor<?> constructor, List<Injectable> cdiSources, Map<InjectionSite, Injectable> postConstruction, Method initMethod, Method destroyMethod, boolean reinjectable, ClassLoader cl) {
        this.implementationClass = constructor.getDeclaringClass();
        this.constructor = constructor;
        this.cdiSources = cdiSources;
        this.postConstruction = postConstruction;
        this.initInvoker = initMethod == null ? null : new MethodEventInvoker(initMethod);
        this.destroyInvoker = destroyMethod == null ? null : new MethodEventInvoker(destroyMethod);
        this.reinjectable = reinjectable;
        this.cl = cl;
    }

    @Override
    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory) {
        this.setObjectFactory(injectable, objectFactory, null);
    }

    @Override
    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory, Object key) {
        if (InjectableType.REFERENCE == injectable.getType() || InjectableType.CALLBACK == injectable.getType()) {
            this.setUpdateableFactory(injectable, objectFactory, key);
        } else {
            this.factories.put(injectable, objectFactory);
        }
    }

    @Override
    public ObjectFactory<?> getObjectFactory(Injectable injectable) {
        return this.factories.get(injectable);
    }

    @Override
    public void removeObjectFactory(Injectable attribute) {
        this.factories.remove(attribute);
    }

    @Override
    public Class<?> getMemberType(Injectable injectable) {
        InjectionSite site = this.findInjectionSite(injectable);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + injectable + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                return method.getParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof ConstructorInjectionSite) {
            try {
                ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
                Constructor method = methodSite.getSignature().getConstructor(this.implementationClass);
                return method.getParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new AssertionError((Object)("Invalid injection site type: " + site.getClass()));
    }

    @Override
    public Type getGenericType(Injectable attribute) {
        InjectionSite site = this.findInjectionSite(attribute);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + attribute + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getGenericType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                return method.getGenericParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof ConstructorInjectionSite) {
            try {
                ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
                Constructor method = methodSite.getSignature().getConstructor(this.implementationClass);
                return method.getGenericParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new AssertionError((Object)("Invalid injection site type " + site.getClass()));
    }

    @Override
    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public InstanceFactory createFactory() {
        ReflectiveObjectFactory factory = new ReflectiveObjectFactory(this.constructor, this.getConstructorParameterFactories(this.cdiSources));
        Map<Injectable, Injector<Object>> mappings = this.createInjectorMappings();
        Injectable[] attributes = mappings.keySet().toArray(new Injectable[mappings.size()]);
        Injector[] injectors = mappings.values().toArray(new Injector[mappings.size()]);
        return new ReflectiveInstanceFactory(factory, attributes, injectors, this.initInvoker, this.destroyInvoker, this.reinjectable, this.cl);
    }

    protected ObjectFactory<?>[] getConstructorParameterFactories(List<Injectable> sources) {
        ObjectFactory[] argumentFactories = new ObjectFactory[sources.size()];
        for (int i = 0; i < argumentFactories.length; ++i) {
            Injectable source = sources.get(i);
            ObjectFactory<?> factory = this.factories.get(source);
            if (factory == null) {
                factory = NULL_FACTORY;
            }
            argumentFactories[i] = factory;
        }
        return argumentFactories;
    }

    protected Map<Injectable, Injector<Object>> createInjectorMappings() {
        LinkedHashMap<Injectable, Injector<Object>> injectors = new LinkedHashMap<Injectable, Injector<Object>>(this.postConstruction.size());
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            InjectionSite site = entry.getKey();
            Injectable attribute = entry.getValue();
            InjectableType type = attribute.getType();
            ObjectFactory<?> factory = this.factories.get(attribute);
            if (factory == null && (type == InjectableType.REFERENCE || type == InjectableType.CALLBACK)) {
                factory = this.createObjectFactory(site.getType());
                this.factories.put(attribute, factory);
            }
            if (factory == null) continue;
            if (site instanceof FieldInjectionSite) {
                try {
                    FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                    Field field = this.getField(fieldSite.getName());
                    injectors.put(attribute, new FieldInjector(field, factory));
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                injectors.put(attribute, new MethodInjector(method, factory));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        return injectors;
    }

    private void setUpdateableFactory(Injectable injectable, ObjectFactory<?> objectFactory, Object key) {
        ObjectFactory<?> factory = this.factories.get(injectable);
        if (factory == null) {
            Class<?> type = this.getMemberType(injectable);
            if (Map.class.equals(type)) {
                MapMultiplicityObjectFactory mapFactory = new MapMultiplicityObjectFactory();
                mapFactory.addObjectFactory(objectFactory, key);
                this.factories.put(injectable, mapFactory);
            } else if (Set.class.equals(type)) {
                SetMultiplicityObjectFactory setFactory = new SetMultiplicityObjectFactory();
                setFactory.addObjectFactory(objectFactory, key);
                this.factories.put(injectable, setFactory);
            } else if (List.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.addObjectFactory(objectFactory, key);
                this.factories.put(injectable, listFactory);
            } else if (Collection.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.addObjectFactory(objectFactory, key);
                this.factories.put(injectable, listFactory);
            } else if (type.isArray()) {
                ArrayMultiplicityObjectFactory arrayFactory = new ArrayMultiplicityObjectFactory(type.getComponentType());
                arrayFactory.addObjectFactory(objectFactory, key);
                this.factories.put(injectable, arrayFactory);
            } else {
                this.factories.put(injectable, objectFactory);
            }
        } else if (factory instanceof MultiplicityObjectFactory) {
            MultiplicityObjectFactory multiplicityObjectFactory = (MultiplicityObjectFactory)factory;
            multiplicityObjectFactory.addObjectFactory(objectFactory, key);
        } else {
            this.factories.put(injectable, objectFactory);
        }
    }

    private InjectionSite findInjectionSite(Injectable attribute) {
        for (int i = 0; i < this.cdiSources.size(); ++i) {
            Injectable injectable = this.cdiSources.get(i);
            if (!attribute.equals((Object)injectable)) continue;
            return new ConstructorInjectionSite(this.constructor, i);
        }
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            if (!entry.getValue().equals((Object)attribute)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.implementationClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private ObjectFactory<?> createObjectFactory(String referenceType) {
        if ("java.util.Map".equals(referenceType)) {
            return new MapMultiplicityObjectFactory();
        }
        if ("java.util.Set".equals(referenceType)) {
            return new SetMultiplicityObjectFactory();
        }
        if ("java.util.List".equals(referenceType)) {
            return new ListMultiplicityObjectFactory();
        }
        if ("java.util.Collection".equals(referenceType)) {
            return new ListMultiplicityObjectFactory();
        }
        return NULL_FACTORY;
    }
}

