/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.util.HashSet;
import java.util.Set;
import org.fabric3.implementation.pojo.reflection.EventInvoker;
import org.fabric3.implementation.pojo.reflection.ObjectCallbackException;
import org.fabric3.spi.Injector;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceInitializationException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.fabric3.spi.model.type.java.Injectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInstanceWrapper
implements InstanceWrapper {
    private final Object instance;
    private boolean reinjectable;
    private final ClassLoader cl;
    private final EventInvoker initInvoker;
    private final EventInvoker destroyInvoker;
    private boolean started;
    private final Injectable[] attributes;
    private final Injector<Object>[] injectors;
    private final Set<Injector<Object>> updatedInjectors;

    public ReflectiveInstanceWrapper(Object instance, boolean reinjectable, ClassLoader cl, EventInvoker initInvoker, EventInvoker destroyInvoker, Injectable[] attributes, Injector<Object>[] injectors) {
        this.instance = instance;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.attributes = attributes;
        this.started = false;
        this.injectors = injectors;
        this.updatedInjectors = reinjectable ? new HashSet<Injector<Object>>() : null;
    }

    public Object getInstance() {
        assert (this.started);
        return this.instance;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start(WorkContext context) throws InstanceInitializationException {
        assert (!this.started);
        if (this.initInvoker != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            WorkContext oldWorkContext = WorkContextTunnel.getThreadWorkContext();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                WorkContextTunnel.setThreadWorkContext((WorkContext)context);
                this.initInvoker.invokeEvent(this.instance);
            }
            catch (ObjectCallbackException e) {
                throw new InstanceInitializationException(e.getMessage(), (Throwable)((Object)e));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
                WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
            }
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(WorkContext context) throws InstanceDestructionException {
        block9: {
            assert (this.started);
            WorkContext oldWorkContext = WorkContextTunnel.getThreadWorkContext();
            try {
                if (this.destroyInvoker == null) break block9;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.cl);
                    WorkContextTunnel.setThreadWorkContext((WorkContext)context);
                    this.destroyInvoker.invokeEvent(this.instance);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                    WorkContextTunnel.setThreadWorkContext((WorkContext)oldWorkContext);
                }
            }
            catch (ObjectCallbackException e) {
                throw new InstanceDestructionException(e.getMessage(), (Throwable)((Object)e));
            }
            finally {
                this.started = false;
            }
        }
    }

    public void reinject() throws InstanceLifecycleException {
        if (!this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable");
        }
        try {
            for (Injector<Object> injector : this.updatedInjectors) {
                injector.inject(this.instance);
            }
            this.updatedInjectors.clear();
        }
        catch (ObjectCreationException ex) {
            throw new InstanceLifecycleException("Unable to reinject references", (Throwable)ex);
        }
    }

    public void updated(String referenceName) {
        if (this.instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable");
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            Injectable attribute = this.attributes[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            if (this.instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }

    public void removed(String referenceName) {
        if (this.instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable");
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            Injectable attribute = this.attributes[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            injector.clearObjectFactory();
            if (this.instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }
}

