/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.fabric3.implementation.pojo.reflection.IncompatibleArgumentException;
import org.fabric3.implementation.pojo.reflection.NullPrimitiveException;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveObjectFactory<T>
implements ObjectFactory<T> {
    private final Constructor<T> constructor;
    private final ObjectFactory<?>[] paramFactories;

    public ReflectiveObjectFactory(Constructor<T> constructor, ObjectFactory<?>[] paramFactories) {
        this.constructor = constructor;
        this.paramFactories = paramFactories;
    }

    public T getInstance() throws ObjectCreationException {
        try {
            if (this.paramFactories == null) {
                return this.constructor.newInstance(new Object[0]);
            }
            Object[] params = new Object[this.paramFactories.length];
            for (int i = 0; i < this.paramFactories.length; ++i) {
                ObjectFactory<?> paramFactory = this.paramFactories[i];
                params[i] = paramFactory.getInstance();
            }
            try {
                return this.constructor.newInstance(params);
            }
            catch (IllegalArgumentException e) {
                Class<?>[] paramTypes = this.constructor.getParameterTypes();
                String name = this.constructor.toString();
                for (int i = 0; i < paramTypes.length; ++i) {
                    Class<?> paramType = paramTypes[i];
                    if (paramType.isPrimitive() && params[i] == null) {
                        throw new NullPrimitiveException(name, i);
                    }
                    if (params[i] == null || !paramType.isInstance(params[i])) continue;
                    throw new IncompatibleArgumentException(name, i, params[i].getClass().getName());
                }
                throw new ObjectCreationException(name, (Throwable)e);
            }
        }
        catch (InstantiationException e) {
            String name = this.constructor.getDeclaringClass().getName();
            throw new AssertionError((Object)("Class is not instantiable:" + name));
        }
        catch (IllegalAccessException e) {
            String id = this.constructor.toString();
            throw new AssertionError((Object)("Constructor is not accessible: " + id));
        }
        catch (InvocationTargetException e) {
            String id = this.constructor.toString();
            throw new ObjectCreationException("Exception thrown by constructor: " + id, id, e.getCause());
        }
    }
}

