/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.provisioning;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.SecuritySubject;
import org.fabric3.federation.provisioning.ProvisionMonitor;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthenticationToken;
import org.fabric3.spi.security.AuthorizationException;
import org.fabric3.spi.security.AuthorizationService;
import org.fabric3.spi.security.UsernamePasswordToken;

public abstract class AbstractResolverServlet
extends HttpServlet {
    private static final long serialVersionUID = 6804699201507293087L;
    protected AuthenticationService authenticationService;
    protected AuthorizationService authorizationService;
    protected String role;
    protected ProvisionMonitor monitor;

    protected AbstractResolverServlet(AuthenticationService authenticationService, AuthorizationService authorizationService, String role, ProvisionMonitor monitor) {
        this.authenticationService = authenticationService;
        this.authorizationService = authorizationService;
        this.role = role;
        this.monitor = monitor;
    }

    protected boolean checkAccess(HttpServletRequest req) {
        if (!req.getRequestURL().toString().toLowerCase().startsWith("https://")) {
            return false;
        }
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        if (username == null || password == null) {
            return false;
        }
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            SecuritySubject subject = this.authenticationService.authenticate((AuthenticationToken)token);
            this.authorizationService.checkRole(subject, this.role);
            return true;
        }
        catch (AuthenticationException e) {
            this.monitor.badAuthentication(e);
            return false;
        }
        catch (AuthorizationException e) {
            this.monitor.badAuthorization(e);
            return false;
        }
    }
}

