/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.provisioning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.provisioning.ProvisionCommand;
import org.fabric3.federation.provisioning.ProvisionMonitor;
import org.fabric3.federation.provisioning.ProvisionResponse;
import org.fabric3.spi.command.ResponseCommand;
import org.fabric3.spi.contribution.ContributionResolverExtension;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class ZoneContributionResolverExtension
implements ContributionResolverExtension {
    private ZoneTopologyService topologyService;
    private ProvisionMonitor monitor;
    private boolean secure;
    private String username;
    private String password;
    private long defaultTimeout = 10000L;

    public ZoneContributionResolverExtension(@Reference ZoneTopologyService topologyService, @Monitor ProvisionMonitor monitor) {
        this.topologyService = topologyService;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Property(required=false)
    public void setUsername(String username) {
        this.username = username;
    }

    @Property(required=false)
    public void setPassword(String password) {
        this.password = password;
    }

    @Property(required=false)
    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    @Init
    public void init() {
        if (this.secure) {
            if (this.username == null) {
                this.monitor.warnUsername();
            }
            if (this.password == null) {
                this.monitor.warnPassword();
            }
        }
    }

    public InputStream resolve(URI contributionUri) throws ResolutionException {
        String zoneLeader = this.topologyService.getZoneLeaderName();
        ProvisionCommand command = new ProvisionCommand(contributionUri);
        try {
            ProvisionResponse response;
            if (this.topologyService.isControllerAvailable()) {
                response = (ProvisionResponse)this.topologyService.sendSynchronousToController((ResponseCommand)command, this.defaultTimeout);
            } else if (!this.topologyService.isZoneLeader() && zoneLeader != null) {
                response = (ProvisionResponse)this.topologyService.sendSynchronous(zoneLeader, (ResponseCommand)command, this.defaultTimeout);
            } else {
                throw new ResolutionException("Unable to contact controller or peer to resolve contribution: " + contributionUri);
            }
            URL url = response.getContributionUrl();
            if (this.secure) {
                url = new URL(url.toString() + "?username=" + this.username + "&password=" + this.password);
            }
            this.monitor.resolving(url);
            return url.openStream();
        }
        catch (MessageException e) {
            throw new ResolutionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResolutionException((Throwable)e);
        }
    }
}

