/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.binding;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.binding.BindingSelector;
import org.fabric3.fabric.binding.NoSCABindingProviderException;
import org.fabric3.spi.binding.provider.BindingMatchResult;
import org.fabric3.spi.binding.provider.BindingProvider;
import org.fabric3.spi.binding.provider.BindingSelectionException;
import org.fabric3.spi.binding.provider.BindingSelectionStrategy;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BindingSelectorImpl
implements BindingSelector {
    private List<BindingProvider> providers = new ArrayList<BindingProvider>();
    private BindingSelectionStrategy strategy;

    @Reference(required=false)
    public void setProviders(List<BindingProvider> providers) {
        this.providers = providers;
        this.orderProviders();
    }

    @Reference(required=false)
    public void setStrategy(BindingSelectionStrategy strategy) {
        this.strategy = strategy;
    }

    @Init
    public void orderProviders() {
        if (this.strategy != null) {
            this.strategy.order(this.providers);
        }
    }

    @Override
    public void selectBindings(LogicalComponent<?> component) throws BindingSelectionException {
        for (LogicalReference reference : component.getReferences()) {
            for (LogicalWire wire : reference.getWires()) {
                LogicalService targetService = wire.getTarget();
                if (targetService == null) continue;
                LogicalComponent targetComponent = (LogicalComponent)targetService.getParent();
                if ("LocalZone".equals(component.getZone()) && "LocalZone".equals(targetComponent.getZone()) || !"LocalZone".equals(component.getZone()) && component.getZone().equals(targetComponent.getZone())) continue;
                this.selectBinding(wire);
            }
        }
        for (LogicalProducer producer : component.getProducers()) {
            LogicalCompositeComponent parent = (LogicalCompositeComponent)component.getParent();
            for (URI uri : producer.getTargets()) {
                LogicalChannel channel = parent.getChannel(uri);
                if (channel == null) {
                    throw new BindingSelectionException("Target channel " + uri + " for " + producer.getUri() + " not found");
                }
                if ("LocalZone".equals(component.getZone()) && "LocalZone".equals(channel.getZone()) || !"LocalZone".equals(component.getZone()) && component.getZone().equals(channel.getZone())) continue;
                this.selectBinding(producer, channel);
            }
        }
    }

    private void selectBinding(LogicalWire wire) throws BindingSelectionException {
        ArrayList<BindingMatchResult> results = new ArrayList<BindingMatchResult>();
        LogicalReference source = wire.getSource();
        LogicalService target = wire.getTarget();
        for (BindingProvider provider : this.providers) {
            BindingMatchResult result = provider.canBind(wire);
            if (result.isMatch()) {
                source.getBindings().clear();
                target.getBindings().clear();
                provider.bind(wire);
                wire.setSourceBinding((LogicalBinding)source.getBindings().get(0));
                wire.setTargetBinding((LogicalBinding)target.getBindings().get(0));
                return;
            }
            results.add(result);
        }
        URI sourceUri = source.getUri();
        URI targetUri = target.getUri();
        throw new NoSCABindingProviderException("No SCA binding provider suitable for creating wire from " + sourceUri + " to " + targetUri, results);
    }

    private void selectBinding(LogicalProducer producer, LogicalChannel channel) throws BindingSelectionException {
        ArrayList<BindingMatchResult> results = new ArrayList<BindingMatchResult>();
        for (BindingProvider provider : this.providers) {
            BindingMatchResult result = provider.canBind(producer, channel);
            if (result.isMatch()) {
                producer.getBindings().clear();
                channel.getBindings().clear();
                provider.bind(producer, channel);
                return;
            }
            results.add(result);
        }
        URI sourceUri = producer.getUri();
        URI targetUri = channel.getUri();
        throw new NoSCABindingProviderException("No SCA binding provider suitable for connecting " + sourceUri + " to " + targetUri, results);
    }
}

