/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.binding.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.fabric3.spi.binding.format.BaseParameterEncoder;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.classloader.ClassLoaderObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKParameterEncoder
extends BaseParameterEncoder {
    public JDKParameterEncoder(ClassLoader loader) {
        super(loader);
    }

    protected byte[] serialize(Object o) throws EncoderException {
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bos);
            stream.writeObject(o);
            stream.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected <T> T deserialize(Class<T> clazz, byte[] bytes, ClassLoader cl) throws EncoderException {
        ByteArrayInputStream bis = null;
        ObjectInputStream stream = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            stream = new ClassLoaderObjectInputStream((InputStream)bis, cl);
            T t = clazz.cast(stream.readObject());
            return t;
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

