/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder;

import java.util.Map;
import org.fabric3.fabric.builder.AttacherNotFoundException;
import org.fabric3.fabric.builder.ChannelConnector;
import org.fabric3.fabric.channel.ChannelConnectionImpl;
import org.fabric3.fabric.channel.EventStreamImpl;
import org.fabric3.fabric.channel.FilterHandler;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.channel.EventFilter;
import org.fabric3.spi.builder.channel.EventFilterBuilder;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelConnectorImpl
implements ChannelConnector {
    private Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers;
    private Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers;
    private Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders;

    @Reference
    public void setSourceAttachers(Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers) {
        this.sourceAttachers = sourceAttachers;
    }

    @Reference
    public void setTargetAttachers(Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers) {
        this.targetAttachers = targetAttachers;
    }

    @Reference
    public void setFilterBuilders(Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders) {
        this.filterBuilders = filterBuilders;
    }

    @Override
    public void connect(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        ChannelConnection connection = this.createConnection(definition);
        sourceAttacher.attach(source, target, connection);
        targetAttacher.attach(source, target, connection);
    }

    @Override
    public void disconnect(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        sourceAttacher.detach(source, target);
        targetAttacher.detach(source, target);
    }

    private ChannelConnection createConnection(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        ChannelConnectionImpl connection = new ChannelConnectionImpl();
        for (PhysicalEventStreamDefinition streamDefinition : definition.getEventStreams()) {
            EventStreamImpl stream = new EventStreamImpl(streamDefinition);
            for (PhysicalEventFilterDefinition filterDefinition : streamDefinition.getFilters()) {
                EventFilterBuilder<? extends PhysicalEventFilterDefinition> filterBuilder = this.filterBuilders.get(filterDefinition.getClass());
                EventFilter filter = filterBuilder.build(filterDefinition);
                FilterHandler handler = new FilterHandler(filter);
                stream.addHandler(handler);
            }
            connection.addEventStream(stream);
        }
        return connection;
    }
}

