/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.classloader;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.fabric.builder.classloader.ClassLoaderBuilder;
import org.fabric3.fabric.builder.classloader.ClassLoaderBuilderException;
import org.fabric3.fabric.builder.classloader.ClassLoaderTracker;
import org.fabric3.host.Names;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.builder.classloader.ClassLoaderListener;
import org.fabric3.spi.builder.classloader.ClassLoaderWireBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.model.physical.PhysicalClassLoaderDefinition;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ClassLoaderBuilderImpl
implements ClassLoaderBuilder {
    private ClassLoaderWireBuilder wireBuilder;
    private ClassLoaderRegistry classLoaderRegistry;
    private ClasspathProcessorRegistry classpathProcessorRegistry;
    private ContributionResolver resolver;
    private ClassLoaderTracker tracker;
    private List<ClassLoaderListener> listeners;
    private HostInfo info;
    private MetaDataStore metaDataStore;

    public ClassLoaderBuilderImpl(@Reference ClassLoaderWireBuilder wireBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ClasspathProcessorRegistry classpathProcessorRegistry, @Reference ContributionResolver resolver, @Reference ClassLoaderTracker tracker, @Reference MetaDataStore metaDataStore, @Reference HostInfo info) {
        this.wireBuilder = wireBuilder;
        this.classLoaderRegistry = classLoaderRegistry;
        this.classpathProcessorRegistry = classpathProcessorRegistry;
        this.resolver = resolver;
        this.tracker = tracker;
        this.metaDataStore = metaDataStore;
        this.info = info;
        this.listeners = Collections.emptyList();
    }

    @Reference(required=false)
    public void setListeners(List<ClassLoaderListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void build(PhysicalClassLoaderDefinition definition) throws ClassLoaderBuilderException {
        URI uri = definition.getUri();
        int count = this.tracker.increment(uri);
        if (this.classLoaderRegistry.getClassLoader(uri) != null) {
            for (PhysicalClassLoaderWireDefinition wireDefinition : definition.getWireDefinitions()) {
                URI target = wireDefinition.getTargetClassLoader();
                ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(target);
                this.tracker.incrementImported(classLoader);
            }
            this.notifyListenersBuild(uri, count);
            return;
        }
        if (this.info.supportsClassLoaderIsolation()) {
            this.buildIsolatedClassLoaderEnvironment(definition);
        } else {
            this.buildCommonClassLoaderEnvironment(definition);
        }
        this.notifyListenersBuild(uri, count);
    }

    @Override
    public void destroy(URI uri) throws ClassLoaderBuilderException {
        block5: {
            int val;
            ClassLoader classLoader;
            block4: {
                classLoader = this.classLoaderRegistry.getClassLoader(uri);
                val = this.tracker.decrement(classLoader);
                if (val != 0 || this.metaDataStore.find(uri) != null) break block4;
                try {
                    this.classLoaderRegistry.unregister(uri);
                    this.resolver.release(uri);
                }
                catch (ResolutionException e) {
                    throw new ClassLoaderBuilderException("Error releasing artifact: " + uri.toString(), e);
                }
                for (ClassLoaderListener listener : this.listeners) {
                    listener.onUndeploy(classLoader);
                }
                break block5;
            }
            if (val != 0) break block5;
            for (ClassLoaderListener listener : this.listeners) {
                listener.onUndeploy(classLoader);
            }
        }
    }

    private void notifyListenersBuild(URI uri, int count) {
        if (count == 1) {
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(uri);
            for (ClassLoaderListener listener : this.listeners) {
                listener.onDeploy(classLoader);
            }
        }
    }

    private void buildCommonClassLoaderEnvironment(PhysicalClassLoaderDefinition definition) {
        URI uri = definition.getUri();
        ClassLoader hostClassLoader = this.classLoaderRegistry.getClassLoader(Names.HOST_CONTRIBUTION);
        this.classLoaderRegistry.register(uri, hostClassLoader);
    }

    private void buildIsolatedClassLoaderEnvironment(PhysicalClassLoaderDefinition definition) throws ClassLoaderBuilderException {
        MultiParentClassLoader loader;
        URI uri = definition.getUri();
        ClassLoader hostClassLoader = this.classLoaderRegistry.getClassLoader(Names.HOST_CONTRIBUTION);
        if (definition.isProvisionArtifact()) {
            URL[] classpath = this.resolveClasspath(definition.getContributionUri());
            loader = new MultiParentClassLoader(uri, classpath, hostClassLoader);
        } else {
            loader = new MultiParentClassLoader(uri, hostClassLoader);
        }
        for (PhysicalClassLoaderWireDefinition wireDefinition : definition.getWireDefinitions()) {
            this.wireBuilder.build(loader, wireDefinition);
            URI target = wireDefinition.getTargetClassLoader();
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(target);
            this.tracker.incrementImported(classLoader);
        }
        this.classLoaderRegistry.register(uri, (ClassLoader)loader);
    }

    private URL[] resolveClasspath(URI uri) throws ClassLoaderBuilderException {
        try {
            URL resolvedUrl = this.resolver.resolve(uri);
            ArrayList classpath = new ArrayList();
            classpath.addAll(this.classpathProcessorRegistry.process(resolvedUrl));
            return classpath.toArray(new URL[classpath.size()]);
        }
        catch (ResolutionException e) {
            throw new ClassLoaderBuilderException("Error resolving artifact: " + uri.toString(), e);
        }
        catch (IOException e) {
            throw new ClassLoaderBuilderException("Error processing: " + uri.toString(), e);
        }
    }
}

