/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.classloader;

import java.net.URI;
import org.fabric3.fabric.builder.classloader.ClassLoaderWireFilter;
import org.fabric3.spi.builder.classloader.ClassLoaderWireBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;
import org.osoa.sca.annotations.Reference;

public class ClassLoaderWireBuilderImpl
implements ClassLoaderWireBuilder {
    private ClassLoaderRegistry registry;

    public ClassLoaderWireBuilderImpl(@Reference ClassLoaderRegistry registry) {
        this.registry = registry;
    }

    public void build(MultiParentClassLoader source, PhysicalClassLoaderWireDefinition wireDefinition) {
        URI uri = wireDefinition.getTargetClassLoader();
        ClassLoader target = this.registry.getClassLoader(uri);
        if (target == null) {
            throw new AssertionError((Object)("Target classloader not found: " + uri));
        }
        String packageName = wireDefinition.getPackageName();
        if (packageName != null) {
            ClassLoaderWireFilter filter = new ClassLoaderWireFilter(target, packageName);
            source.addParent((ClassLoader)filter);
        } else {
            source.addParent(target);
        }
    }
}

