/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.fabric.channel.FanOutHandler;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.PassThroughHandler;

public class ChannelImpl
implements Channel {
    private URI uri;
    private QName deployable;
    private EventStreamHandler headHandler;
    private EventStreamHandler tailHandler;
    private EventStreamHandler inHandler;
    private FanOutHandler fanOutHandler;

    public ChannelImpl(URI uri, QName deployable, FanOutHandler handler) {
        this.uri = uri;
        this.deployable = deployable;
        this.inHandler = new PassThroughHandler();
        this.fanOutHandler = handler;
        this.inHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public void addHandler(EventStreamHandler handler) {
        if (this.headHandler == null) {
            this.headHandler = handler;
            this.inHandler.setNext(handler);
        } else {
            this.tailHandler.setNext(handler);
        }
        this.tailHandler = handler;
        this.tailHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public void attach(EventStreamHandler handler) {
        handler.setNext(this.inHandler);
    }

    public void attach(ChannelConnection connection) {
        for (EventStream stream : connection.getEventStreams()) {
            stream.getTailHandler().setNext(this.inHandler);
        }
    }

    public void subscribe(URI uri, ChannelConnection connection) {
        this.fanOutHandler.addConnection(uri, connection);
    }

    public ChannelConnection unsubscribe(URI uri) {
        return this.fanOutHandler.removeConnection(uri);
    }
}

