/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.collector;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.collector.Collector;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorImpl
implements Collector {
    @Override
    public void markAsProvisioned(LogicalCompositeComponent composite) {
        for (LogicalComponent component : composite.getComponents()) {
            if (component instanceof LogicalCompositeComponent) {
                this.markAsProvisioned((LogicalCompositeComponent)component);
            }
            if (LogicalState.NEW == component.getState()) {
                component.setState(LogicalState.PROVISIONED);
            }
            for (LogicalService service : component.getServices()) {
                for (LogicalBinding binding : service.getBindings()) {
                    if (LogicalState.NEW != binding.getState()) continue;
                    binding.setState(LogicalState.PROVISIONED);
                }
                for (LogicalBinding binding : service.getCallbackBindings()) {
                    if (LogicalState.NEW != binding.getState()) continue;
                    binding.setState(LogicalState.PROVISIONED);
                }
            }
            for (LogicalReference reference : component.getReferences()) {
                for (LogicalBinding binding : reference.getBindings()) {
                    if (LogicalState.NEW != binding.getState()) continue;
                    binding.setState(LogicalState.PROVISIONED);
                }
                for (LogicalBinding binding : reference.getCallbackBindings()) {
                    if (LogicalState.NEW != binding.getState()) continue;
                    binding.setState(LogicalState.PROVISIONED);
                }
            }
        }
        for (List wires : composite.getWires().values()) {
            for (LogicalWire wire : wires) {
                if (LogicalState.NEW != wire.getState()) continue;
                wire.setState(LogicalState.PROVISIONED);
            }
        }
        for (LogicalChannel channel : composite.getChannels()) {
            if (LogicalState.NEW != channel.getState()) continue;
            channel.setState(LogicalState.PROVISIONED);
        }
        for (LogicalResource resource : composite.getResources()) {
            if (LogicalState.NEW != resource.getState()) continue;
            resource.setState(LogicalState.PROVISIONED);
        }
    }

    @Override
    public void markForCollection(QName deployable, LogicalCompositeComponent composite) {
        for (LogicalComponent component : composite.getComponents()) {
            if (deployable.equals(component.getDeployable())) {
                if (component instanceof LogicalCompositeComponent) {
                    this.markForCollection(deployable, (LogicalCompositeComponent)component);
                }
                component.setState(LogicalState.MARKED);
                for (LogicalService service : component.getServices()) {
                    for (LogicalBinding binding : service.getBindings()) {
                        binding.setState(LogicalState.MARKED);
                    }
                }
                for (LogicalReference reference : component.getReferences()) {
                    for (LogicalBinding binding : reference.getBindings()) {
                        binding.setState(LogicalState.MARKED);
                    }
                    for (LogicalWire wire : composite.getWires(reference)) {
                        wire.setState(LogicalState.MARKED);
                    }
                }
                continue;
            }
            for (LogicalService service : component.getServices()) {
                for (LogicalBinding binding : service.getBindings()) {
                    if (!deployable.equals(binding.getDeployable())) continue;
                    binding.setState(LogicalState.MARKED);
                }
                for (LogicalBinding binding : service.getCallbackBindings()) {
                    if (!deployable.equals(binding.getDeployable())) continue;
                    binding.setState(LogicalState.MARKED);
                }
            }
            for (List wires : composite.getWires().values()) {
                for (LogicalWire wire : wires) {
                    if (LogicalState.MARKED == wire.getState() || !deployable.equals(wire.getTargetDeployable())) continue;
                    wire.setState(LogicalState.MARKED);
                }
            }
        }
        for (LogicalChannel channel : composite.getChannels()) {
            if (!deployable.equals(channel.getDeployable())) continue;
            channel.setState(LogicalState.MARKED);
        }
        for (LogicalResource resource : composite.getResources()) {
            resource.setState(LogicalState.MARKED);
        }
    }

    @Override
    public void collect(LogicalCompositeComponent composite) {
        Iterator iter = composite.getComponents().iterator();
        while (iter.hasNext()) {
            LogicalComponent component = (LogicalComponent)iter.next();
            if (LogicalState.MARKED == component.getState()) {
                iter.remove();
                continue;
            }
            for (LogicalService service : component.getServices()) {
                this.removeMarkedBindings(service.getBindings().iterator());
                this.removeMarkedBindings(service.getCallbackBindings().iterator());
            }
            for (LogicalReference reference : component.getReferences()) {
                this.removeMarkedBindings(reference.getBindings().iterator());
                this.removeMarkedBindings(reference.getCallbackBindings().iterator());
            }
            if (!(component instanceof LogicalCompositeComponent)) continue;
            this.collect((LogicalCompositeComponent)component);
        }
        for (List wires : composite.getWires().values()) {
            Iterator it = wires.iterator();
            while (it.hasNext()) {
                LogicalWire wire = (LogicalWire)it.next();
                if (LogicalState.MARKED != wire.getState()) continue;
                it.remove();
            }
        }
        Iterator channelIter = composite.getChannels().iterator();
        while (channelIter.hasNext()) {
            LogicalChannel channel = (LogicalChannel)channelIter.next();
            if (LogicalState.MARKED != channel.getState()) continue;
            channelIter.remove();
        }
        Iterator resourceIter = composite.getResources().iterator();
        while (resourceIter.hasNext()) {
            LogicalResource resource = (LogicalResource)resourceIter.next();
            if (LogicalState.MARKED != resource.getState()) continue;
            resourceIter.remove();
        }
    }

    private void removeMarkedBindings(Iterator<LogicalBinding<?>> iter) {
        while (iter.hasNext()) {
            LogicalBinding<?> binding = iter.next();
            if (LogicalState.MARKED != binding.getState()) continue;
            iter.remove();
        }
    }
}

