/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ConversationExpirationCallback;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.invocation.F3Conversation;
import org.fabric3.spi.invocation.WorkContext;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeContainer
implements ScopeContainer {
    private final Scope scope;
    protected final ScopeContainerMonitor monitor;
    private ScopeRegistry scopeRegistry;

    public AbstractScopeContainer(Scope scope, ScopeContainerMonitor monitor) {
        this.scope = scope;
        this.monitor = monitor;
    }

    @Reference
    public void setScopeRegistry(ScopeRegistry scopeRegistry) {
        this.scopeRegistry = scopeRegistry;
    }

    public synchronized void start() {
        if (this.scopeRegistry != null) {
            this.scopeRegistry.register((ScopeContainer)this);
        }
    }

    public synchronized void stop() {
        if (this.scopeRegistry != null) {
            this.scopeRegistry.unregister((ScopeContainer)this);
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public void register(AtomicComponent component) {
    }

    public void unregister(AtomicComponent component) {
    }

    public void registerCallback(F3Conversation conversation, ConversationExpirationCallback callback) {
        throw new UnsupportedOperationException();
    }

    public void initializeComponents(List<AtomicComponent> components, WorkContext workContext) throws GroupInitializationException {
        ArrayList<Exception> causes = null;
        for (AtomicComponent component : components) {
            try {
                this.getWrapper(component, workContext);
            }
            catch (Exception e) {
                this.monitor.eagerInitializationError(component.getUri(), e);
                if (causes == null) {
                    causes = new ArrayList<Exception>();
                }
                causes.add(e);
            }
        }
        if (causes != null) {
            throw new GroupInitializationException(causes);
        }
    }

    public String toString() {
        return "In state [" + super.toString() + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyInstances(List<InstanceWrapper> instances, WorkContext workContext) {
        while (true) {
            InstanceWrapper toDestroy;
            List<InstanceWrapper> list = instances;
            synchronized (list) {
                if (instances.size() == 0) {
                    return;
                }
                toDestroy = instances.remove(instances.size() - 1);
            }
            try {
                toDestroy.stop(workContext);
                continue;
            }
            catch (InstanceDestructionException e) {
                this.monitor.destructionError(e);
                continue;
            }
            break;
        }
    }
}

