/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.component.scope.AbstractScopeContainer;
import org.fabric3.fabric.component.scope.InstanceWrapperStore;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.ConversationExpirationCallback;
import org.fabric3.spi.component.ExpirationPolicy;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceInitializationException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.ConversationContext;
import org.fabric3.spi.invocation.F3Conversation;
import org.fabric3.spi.invocation.WorkContext;
import org.osoa.sca.ConversationEndedException;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value=ScopeContainer.class)
@EagerInit
public class ConversationalScopeContainer
extends AbstractScopeContainer {
    private final Map<F3Conversation, ExpirationPolicy> expirationPolicies;
    private final Map<F3Conversation, List<ConversationExpirationCallback>> expirationCallbacks;
    private final InstanceWrapperStore<F3Conversation> store;
    private ScheduledExecutorService executor;
    private long delay = 600L;
    private final Map<F3Conversation, List<InstanceWrapper>> destroyQueues = new ConcurrentHashMap<F3Conversation, List<InstanceWrapper>>();

    public ConversationalScopeContainer(@Monitor ScopeContainerMonitor monitor, @Reference(name="store") InstanceWrapperStore<F3Conversation> store) {
        super(Scope.CONVERSATION, monitor);
        this.store = store;
        this.expirationPolicies = new ConcurrentHashMap<F3Conversation, ExpirationPolicy>();
        this.expirationCallbacks = new ConcurrentHashMap<F3Conversation, List<ConversationExpirationCallback>>();
    }

    @Property
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    @Init
    public void start() {
        super.start();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        Reaper reaper = new Reaper();
        this.executor.scheduleWithFixedDelay(reaper, this.delay, this.delay, TimeUnit.SECONDS);
    }

    @Override
    @Destroy
    public void stop() {
        this.executor.shutdownNow();
        this.destroyQueues.clear();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCallback(F3Conversation conversation, ConversationExpirationCallback callback) {
        List<ConversationExpirationCallback> callbacks = this.expirationCallbacks.get(conversation);
        if (callbacks == null) {
            callbacks = new ArrayList<ConversationExpirationCallback>();
            this.expirationCallbacks.put(conversation, callbacks);
        }
        List<ConversationExpirationCallback> list = callbacks;
        synchronized (list) {
            callbacks.add(callback);
        }
    }

    public void startContext(WorkContext workContext) throws ComponentException {
        this.startContext(workContext, null);
    }

    public void startContext(WorkContext workContext, ExpirationPolicy policy) throws ComponentException {
        F3Conversation conversation = workContext.peekCallFrame().getConversation();
        assert (conversation != null);
        this.store.startContext(conversation);
        this.destroyQueues.put(conversation, new ArrayList());
        if (policy != null) {
            this.expirationPolicies.put(conversation, policy);
        }
    }

    public void joinContext(WorkContext workContext) throws GroupInitializationException {
        this.joinContext(workContext, null);
    }

    public void joinContext(WorkContext workContext, ExpirationPolicy policy) {
        F3Conversation conversation = workContext.peekCallFrame().getConversation();
        assert (conversation != null);
        if (!this.destroyQueues.containsKey(conversation)) {
            this.destroyQueues.put(conversation, new ArrayList());
            if (policy != null) {
                this.expirationPolicies.put(conversation, policy);
            }
        }
    }

    public void stopContext(WorkContext workContext) throws ComponentException {
        F3Conversation conversation = workContext.peekCallFrame().getConversation();
        assert (conversation != null);
        this.stopContext(conversation, workContext);
        this.expirationPolicies.remove(conversation);
        this.notifyExpirationCallbacks(conversation);
    }

    private void stopContext(F3Conversation conversation, WorkContext workContext) throws InstanceLifecycleException {
        List<InstanceWrapper> list = this.destroyQueues.remove(conversation);
        if (list == null) {
            throw new IllegalStateException("Conversation does not exist: " + conversation);
        }
        this.destroyInstances(list, workContext);
        this.store.stopContext(conversation);
    }

    public InstanceWrapper getWrapper(AtomicComponent component, WorkContext workContext) throws InstanceLifecycleException {
        ConversationContext context;
        boolean create;
        InstanceWrapper wrapper;
        CallFrame frame = workContext.peekCallFrame();
        F3Conversation conversation = frame.getConversation();
        assert (conversation != null);
        ExpirationPolicy policy = this.expirationPolicies.get(conversation);
        if (policy != null && !policy.isExpired()) {
            this.expirationPolicies.get(conversation).renew();
        }
        if ((wrapper = this.getWrapper(component, workContext, conversation, create = (context = frame.getConversationContext()) == ConversationContext.NEW || context == ConversationContext.PROPAGATE)) == null) {
            throw new ConversationEndedException("Conversation ended");
        }
        return wrapper;
    }

    public void reinject() {
    }

    public void updated(AtomicComponent component, String referenceName) {
    }

    public void removed(AtomicComponent component, String referenceName) {
    }

    public void returnWrapper(AtomicComponent component, WorkContext workContext, InstanceWrapper wrapper) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExpirationCallbacks(F3Conversation conversation) {
        List<ConversationExpirationCallback> callbacks = this.expirationCallbacks.remove(conversation);
        if (callbacks != null) {
            List<ConversationExpirationCallback> list = callbacks;
            synchronized (list) {
                for (ConversationExpirationCallback callback : callbacks) {
                    callback.expire(conversation);
                }
            }
        }
    }

    private InstanceWrapper getWrapper(AtomicComponent component, WorkContext workContext, F3Conversation conversation, boolean create) throws InstanceLifecycleException {
        InstanceWrapper wrapper = this.store.getWrapper(component, conversation);
        if (wrapper == null && create) {
            try {
                wrapper = component.createInstanceWrapper(workContext);
            }
            catch (ObjectCreationException e) {
                throw new InstanceInitializationException("Error creating instance for: " + component.getUri(), (Throwable)e);
            }
            wrapper.start(workContext);
            this.store.putWrapper(component, conversation, wrapper);
            List<InstanceWrapper> queue = this.destroyQueues.get(conversation);
            if (queue == null) {
                throw new IllegalStateException("Instance context not found for : " + component.getUri());
            }
            queue.add(wrapper);
        }
        return wrapper;
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        public void run() {
            Iterator iterator = ConversationalScopeContainer.this.expirationPolicies.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((ExpirationPolicy)entry.getValue()).isExpired()) continue;
                F3Conversation conversation = (F3Conversation)entry.getKey();
                iterator.remove();
                WorkContext workContext = new WorkContext();
                CallFrame frame = new CallFrame(null, (Serializable)conversation, conversation, null);
                workContext.addCallFrame(frame);
                try {
                    ConversationalScopeContainer.this.stopContext(conversation, workContext);
                }
                catch (InstanceLifecycleException e) {
                    ConversationalScopeContainer.this.monitor.error((Exception)((Object)e));
                }
                ConversationalScopeContainer.this.notifyExpirationCallbacks(conversation);
            }
        }
    }
}

