/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.fabric.component.scope.SingletonScopeContainer;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.federation.TopologyListener;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.WorkContext;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Service(interfaces={ScopeContainer.class, TopologyListener.class})
public class DomainScopeContainer
extends SingletonScopeContainer
implements TopologyListener {
    private HostInfo info;
    private ZoneTopologyService topologyService;
    private final List<QName> deferredContexts = new ArrayList<QName>();
    boolean activated;

    public DomainScopeContainer(@Reference HostInfo info, @Monitor ScopeContainerMonitor monitor) {
        super(Scope.DOMAIN, monitor);
        this.info = info;
    }

    @Reference(required=false)
    public void setTopologyService(List<ZoneTopologyService> topologyServices) {
        if (topologyServices.size() > 0) {
            this.topologyService = topologyServices.get(0);
        }
    }

    @Override
    @Init
    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContext(WorkContext workContext) throws GroupInitializationException {
        QName contextId = (QName)workContext.peekCallFrame().getCorrelationId(QName.class);
        if (RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() && this.topologyService == null) {
            return;
        }
        if (RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() && !this.topologyService.isZoneLeader()) {
            List<QName> list = this.deferredContexts;
            synchronized (list) {
                this.deferredContexts.add(contextId);
            }
            return;
        }
        this.activated = true;
        super.startContext(workContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContext(WorkContext workContext) {
        QName contextId = (QName)workContext.peekCallFrame().getCorrelationId(QName.class);
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.remove(contextId);
        }
        super.stopContext(workContext);
    }

    @Override
    public InstanceWrapper getWrapper(AtomicComponent component, WorkContext workContext) throws InstanceLifecycleException {
        if (this.topologyService != null && !this.activated) {
            throw new InstanceLifecycleException("Component instance not active: " + component.getUri());
        }
        return super.getWrapper(component, workContext);
    }

    public void onJoin(String name) {
    }

    public void onLeave(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaderElected(String name) {
        if (this.topologyService != null && !this.topologyService.isZoneLeader()) {
            return;
        }
        this.activated = true;
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            for (QName contextId : this.deferredContexts) {
                WorkContext workContext = new WorkContext();
                CallFrame frame = new CallFrame((Serializable)contextId);
                workContext.addCallFrame(frame);
                try {
                    super.startContext(workContext);
                }
                catch (GroupInitializationException e) {
                    this.monitor.error((Exception)((Object)e));
                }
            }
            this.deferredContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllContexts(WorkContext workContext) {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stopAllContexts(workContext);
    }
}

