/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.component.scope.AbstractScopeContainer;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ExpirationPolicy;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceInitializationException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.invocation.WorkContext;
import org.osoa.sca.annotations.Destroy;

public abstract class SingletonScopeContainer
extends AbstractScopeContainer {
    private final Map<AtomicComponent, InstanceWrapper> instanceWrappers;
    private final Map<QName, List<InstanceWrapper>> destroyQueues;
    private final Map<QName, List<AtomicComponent>> initQueues = new HashMap<QName, List<AtomicComponent>>();
    private final Map<AtomicComponent, CountDownLatch> pending;
    private static final InstanceWrapper EMPTY = new InstanceWrapper(){

        public Object getInstance() {
            return null;
        }

        public boolean isStarted() {
            return true;
        }

        public void start(WorkContext workContext) {
        }

        public void stop(WorkContext workContext) {
        }

        public void reinject() {
        }

        public void updated(String referenceName) {
        }

        public void removed(String referenceName) {
        }
    };

    protected SingletonScopeContainer(Scope scope, @Monitor ScopeContainerMonitor monitor) {
        super(scope, monitor);
        this.instanceWrappers = new ConcurrentHashMap<AtomicComponent, InstanceWrapper>();
        this.pending = new ConcurrentHashMap<AtomicComponent, CountDownLatch>();
        this.destroyQueues = new LinkedHashMap<QName, List<InstanceWrapper>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AtomicComponent component) {
        super.register(component);
        if (component.isEagerInit()) {
            QName deployable = component.getDeployable();
            Map<QName, List<AtomicComponent>> map = this.initQueues;
            synchronized (map) {
                List<AtomicComponent> initQueue = this.initQueues.get(deployable);
                if (initQueue == null) {
                    initQueue = new ArrayList<AtomicComponent>();
                    this.initQueues.put(deployable, initQueue);
                }
                initQueue.add(component);
            }
        }
        this.instanceWrappers.put(component, EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(AtomicComponent component) {
        super.unregister(component);
        this.instanceWrappers.remove(component);
        if (component.isEagerInit()) {
            QName deployable = component.getDeployable();
            Map<QName, List<AtomicComponent>> map = this.initQueues;
            synchronized (map) {
                List<AtomicComponent> initQueue = this.initQueues.get(deployable);
                initQueue.remove(component);
                if (initQueue.isEmpty()) {
                    this.initQueues.remove(deployable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext(WorkContext workContext) throws GroupInitializationException {
        QName deployable = (QName)workContext.peekCallFrame().getCorrelationId(QName.class);
        this.eagerInitialize(workContext, deployable);
        Map<QName, List<InstanceWrapper>> map = this.destroyQueues;
        synchronized (map) {
            if (!this.destroyQueues.containsKey(deployable)) {
                this.destroyQueues.put(deployable, new ArrayList());
            }
        }
    }

    public void startContext(WorkContext workContext, ExpirationPolicy policy) throws GroupInitializationException {
        this.startContext(workContext);
    }

    public void joinContext(WorkContext workContext) throws GroupInitializationException {
    }

    public void joinContext(WorkContext workContext, ExpirationPolicy policy) throws GroupInitializationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContext(WorkContext workContext) {
        QName deployable = (QName)workContext.peekCallFrame().getCorrelationId(QName.class);
        Map<QName, List<InstanceWrapper>> map = this.destroyQueues;
        synchronized (map) {
            List<InstanceWrapper> list = this.destroyQueues.get(deployable);
            if (list == null) {
                throw new IllegalStateException("Context does not exist: " + deployable);
            }
            this.destroyInstances(list, workContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Destroy
    public synchronized void stop() {
        super.stop();
        Map<QName, List<InstanceWrapper>> map = this.destroyQueues;
        synchronized (map) {
            this.destroyQueues.clear();
        }
        map = this.initQueues;
        synchronized (map) {
            this.initQueues.clear();
        }
        this.instanceWrappers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceWrapper getWrapper(AtomicComponent component, WorkContext workContext) throws InstanceLifecycleException {
        CountDownLatch latch;
        InstanceWrapper wrapper = this.instanceWrappers.get(component);
        if (wrapper != EMPTY) {
            if (wrapper == null) {
                throw new InstanceInitializationException("Instance wrapper not found for " + component.getUri());
            }
            return wrapper;
        }
        AtomicComponent atomicComponent = component;
        synchronized (atomicComponent) {
            latch = this.pending.get(component);
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InstanceInitializationException("Error creating instance for: " + component.getUri(), (Throwable)e);
                }
                return this.instanceWrappers.get(component);
            }
            latch = new CountDownLatch(1);
            this.pending.put(component, latch);
        }
        try {
            Object queue;
            wrapper = component.createInstanceWrapper(workContext);
            if (!wrapper.isStarted()) {
                wrapper.start(workContext);
                QName deployable = component.getDeployable();
                Map<QName, List<InstanceWrapper>> map = this.destroyQueues;
                synchronized (map) {
                    queue = this.destroyQueues.get(deployable);
                    if (queue == null) {
                        queue = new ArrayList();
                        this.destroyQueues.put(deployable, (List<InstanceWrapper>)queue);
                    }
                }
                queue.add(wrapper);
            }
            this.instanceWrappers.put(component, wrapper);
            latch.countDown();
            queue = wrapper;
            return queue;
        }
        catch (ObjectCreationException e) {
            throw new InstanceInitializationException("Error creating instance for: " + component.getUri(), (Throwable)e);
        }
        finally {
            this.pending.remove(component);
        }
    }

    public void returnWrapper(AtomicComponent component, WorkContext workContext, InstanceWrapper wrapper) {
    }

    public void updated(AtomicComponent component, String referenceName) {
        InstanceWrapper wrapper = this.instanceWrappers.get(component);
        if (wrapper != null) {
            wrapper.updated(referenceName);
        }
    }

    public void removed(AtomicComponent component, String referenceName) {
        InstanceWrapper wrapper = this.instanceWrappers.get(component);
        if (wrapper != null) {
            wrapper.removed(referenceName);
        }
    }

    public void reinject() throws InstanceLifecycleException {
        for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
            instanceWrapper.reinject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllContexts(WorkContext workContext) {
        Map<QName, List<InstanceWrapper>> map = this.destroyQueues;
        synchronized (map) {
            ArrayList<List<InstanceWrapper>> queues = new ArrayList<List<InstanceWrapper>>(this.destroyQueues.values());
            ListIterator iter = queues.listIterator(queues.size());
            while (iter.hasPrevious()) {
                List queue = (List)iter.previous();
                this.destroyInstances(queue, workContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerInitialize(WorkContext workContext, QName contextId) throws GroupInitializationException {
        List<AtomicComponent> initQueue;
        Map<QName, List<AtomicComponent>> map = this.initQueues;
        synchronized (map) {
            initQueue = this.initQueues.get(contextId);
            if (initQueue != null) {
                initQueue = new ArrayList<AtomicComponent>(initQueue);
            }
        }
        if (initQueue != null) {
            this.initializeComponents(initQueue, workContext);
        }
    }
}

