/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.contract;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.ContractMatcherExtension;
import org.fabric3.spi.contract.MatchResult;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContractMatcher
implements ContractMatcher {
    private Map<Key, ContractMatcherExtension<?, ?>> cache = new HashMap();

    @Reference
    public void setMatcherExtensions(List<ContractMatcherExtension<?, ?>> matchers) {
        this.cache.clear();
        for (ContractMatcherExtension<?, ?> matcher : matchers) {
            this.addMatcherExtension(matcher);
        }
    }

    public void addMatcherExtension(ContractMatcherExtension<?, ?> matcher) {
        Key key = new Key(matcher.getSource(), matcher.getTarget());
        this.cache.put(key, matcher);
    }

    public MatchResult isAssignableFrom(ServiceContract source, ServiceContract target, boolean reportErrors) {
        Key key = new Key(source.getClass(), target.getClass());
        ContractMatcherExtension<?, ?> matcher = this.cache.get(key);
        if (matcher == null) {
            String name = ContractMatcherExtension.class.getSimpleName();
            throw new AssertionError((Object)(name + " not found for converting from " + source.getClass() + " to " + target.getClass()));
        }
        return matcher.isAssignableFrom(source, target, reportErrors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Key {
        private Class<? extends ServiceContract> source;
        private Class<? extends ServiceContract> target;

        private Key(Class<? extends ServiceContract> source, Class<? extends ServiceContract> target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return !(this.source == null ? that.source != null : !this.source.equals(that.source)) && !(this.target == null ? that.target != null : !this.target.equals(that.target));
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}

