/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.domain.CompositeAlreadyDeployedException;
import org.fabric3.host.domain.DeployableNotFoundException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.component.Composite;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.plan.DeploymentPlan;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionHelperImpl
implements ContributionHelper {
    private static final String PLAN_NAMESPACE = "urn:fabric3.org:extension:plan";
    private MetaDataStore metadataStore;
    private HostInfo hostInfo;

    public ContributionHelperImpl(@Reference MetaDataStore metadataStore, @Reference HostInfo hostInfo) {
        this.metadataStore = metadataStore;
        this.hostInfo = hostInfo;
    }

    @Override
    public List<Composite> getDeployables(Set<Contribution> contributions) {
        ArrayList<Composite> deployables = new ArrayList<Composite>();
        for (Contribution contribution : contributions) {
            for (Resource resource : contribution.getResources()) {
                block2: for (ResourceElement entry : resource.getResourceElements()) {
                    if (!(entry.getValue() instanceof Composite)) continue;
                    ResourceElement element = entry;
                    QName name = (QName)((QNameSymbol)element.getSymbol()).getKey();
                    Composite composite = (Composite)element.getValue();
                    for (Deployable deployable : contribution.getManifest().getDeployables()) {
                        if (!deployable.getName().equals(name)) continue;
                        List deployableModes = deployable.getRuntimeModes();
                        if (!deployableModes.contains(this.hostInfo.getRuntimeMode())) continue block2;
                        deployables.add(composite);
                        continue block2;
                    }
                }
            }
        }
        return deployables;
    }

    @Override
    public Composite findComposite(QName deployable) throws DeploymentException {
        QNameSymbol symbol = new QNameSymbol(deployable);
        ResourceElement element = this.metadataStore.find(Composite.class, (Symbol)symbol);
        if (element == null) {
            String id = deployable.toString();
            throw new DeployableNotFoundException("Deployable not found: " + id, id);
        }
        return (Composite)element.getValue();
    }

    @Override
    public DeploymentPlan findDefaultPlan(QName deployable) {
        QNameSymbol symbol = new QNameSymbol(deployable);
        Contribution contribution = this.metadataStore.find(Composite.class, (Symbol)symbol).getResource().getContribution();
        return this.findDefaultPlan(contribution);
    }

    @Override
    public DeploymentPlan findDefaultPlan(Contribution contribution) {
        ArrayList<DeploymentPlan> plans = new ArrayList<DeploymentPlan>();
        this.getDeploymentPlans(contribution, plans);
        if (plans.isEmpty()) {
            return null;
        }
        DeploymentPlan plan = (DeploymentPlan)plans.get(0);
        return plan;
    }

    @Override
    public DeploymentPlan findPlan(String plan) throws DeploymentException {
        QName planName = new QName(PLAN_NAMESPACE, plan);
        QNameSymbol symbol = new QNameSymbol(planName);
        ResourceElement element = this.metadataStore.find(DeploymentPlan.class, (Symbol)symbol);
        if (element == null) {
            return null;
        }
        return (DeploymentPlan)element.getValue();
    }

    @Override
    public Set<Contribution> findContributions(List<URI> uris) {
        LinkedHashSet<Contribution> contributions = new LinkedHashSet<Contribution>(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.metadataStore.find(uri);
            contributions.add(contribution);
        }
        return contributions;
    }

    @Override
    public void lock(Set<Contribution> contributions) throws CompositeAlreadyDeployedException {
        for (Contribution contribution : contributions) {
            for (Deployable deployable : contribution.getManifest().getDeployables()) {
                QName name = deployable.getName();
                if (contribution.getLockOwners().contains(name)) {
                    throw new CompositeAlreadyDeployedException("Composite has already been deployed: " + name);
                }
                contribution.acquireLock(name);
            }
        }
    }

    @Override
    public void releaseLocks(Set<Contribution> contributions) {
        for (Contribution contribution : contributions) {
            for (Deployable deployable : contribution.getManifest().getDeployables()) {
                QName name = deployable.getName();
                if (!contribution.getLockOwners().contains(name)) continue;
                contribution.releaseLock(name);
            }
        }
    }

    private void getDeploymentPlans(Contribution contribution, List<DeploymentPlan> plans) {
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement entry : resource.getResourceElements()) {
                if (!(entry.getValue() instanceof DeploymentPlan)) continue;
                ResourceElement element = entry;
                DeploymentPlan plan = (DeploymentPlan)element.getValue();
                plans.add(plan);
            }
        }
    }
}

