/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.util.List;
import java.util.ListIterator;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeployerMonitor;
import org.fabric3.spi.domain.DeploymentPackage;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.generator.DeploymentUnit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDeployer
implements Deployer {
    private CommandExecutorRegistry executorRegistry;
    private ScopeRegistry scopeRegistry;
    private DeployerMonitor monitor;

    public LocalDeployer(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Monitor DeployerMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.scopeRegistry = scopeRegistry;
        this.monitor = monitor;
    }

    public void deploy(DeploymentPackage deploymentPackage) throws DeploymentException {
        DeploymentUnit unit = deploymentPackage.getCurrentDeployment().getDeploymentUnit("LocalZone");
        List provisionCommands = unit.getProvisionCommands();
        this.execute(provisionCommands);
        List commands = unit.getCommands();
        this.execute(commands);
        try {
            if (this.scopeRegistry != null) {
                this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
            }
        }
        catch (InstanceLifecycleException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void execute(List<CompensatableCommand> commands) throws DeploymentException {
        int marker = 0;
        for (CompensatableCommand command : commands) {
            try {
                this.executorRegistry.execute((Command)command);
                ++marker;
            }
            catch (ExecutionException e) {
                this.rollback(commands, marker);
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    private void rollback(List<CompensatableCommand> commands, int marker) {
        try {
            this.monitor.rollback("local");
            ListIterator<CompensatableCommand> iter = commands.listIterator(marker);
            while (iter.hasPrevious()) {
                CompensatableCommand command = iter.previous();
                CompensatableCommand compensating = command.getCompensatingCommand();
                this.executorRegistry.execute((Command)compensating);
            }
            if (this.scopeRegistry != null) {
                this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
            }
        }
        catch (ExecutionException ex) {
            this.monitor.rollbackError("local", (Throwable)ex);
        }
        catch (InstanceLifecycleException ex) {
            this.monitor.rollbackError("local", (Throwable)ex);
        }
    }
}

