/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.fabric3.fabric.channel.AbstractFanOutHandler;
import org.fabric3.fabric.channel.AsyncFanOutHandler;
import org.fabric3.fabric.channel.ChannelImpl;
import org.fabric3.fabric.channel.SyncFanOutHandler;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.RegistrationException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BuildChannelsCommandExecutor
implements CommandExecutor<BuildChannelsCommand> {
    private ChannelManager channelManager;
    private ExecutorService executorService;
    private CommandExecutorRegistry executorRegistry;

    @Constructor
    public BuildChannelsCommandExecutor(@Reference ChannelManager channelManager, @Reference ExecutorService executorService, @Reference CommandExecutorRegistry executorRegistry) {
        this.channelManager = channelManager;
        this.executorService = executorService;
        this.executorRegistry = executorRegistry;
    }

    @Init
    public void init() {
        this.executorRegistry.register(BuildChannelsCommand.class, (CommandExecutor)this);
    }

    public void execute(BuildChannelsCommand command) throws ExecutionException {
        try {
            List<PhysicalChannelDefinition> definitions = command.getDefinitions();
            for (PhysicalChannelDefinition definition : definitions) {
                URI uri = definition.getUri();
                QName deployable = definition.getDeployable();
                AbstractFanOutHandler handler = definition.isSynchronous() ? new SyncFanOutHandler() : new AsyncFanOutHandler(this.executorService);
                ChannelImpl channel = new ChannelImpl(uri, deployable, handler);
                this.channelManager.register((Channel)channel);
            }
        }
        catch (RegistrationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

