/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.Map;
import org.fabric3.fabric.builder.BuilderNotFoundException;
import org.fabric3.fabric.command.BuildComponentCommand;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ComponentBuilder;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.cm.RegistrationException;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BuildComponentCommandExecutor
implements CommandExecutor<BuildComponentCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;
    private Map<Class<?>, ComponentBuilder> builders;

    @Constructor
    public BuildComponentCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    public BuildComponentCommandExecutor(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(BuildComponentCommand.class, (CommandExecutor)this);
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ComponentBuilder> builders) {
        this.builders = builders;
    }

    public void execute(BuildComponentCommand command) throws ExecutionException {
        try {
            PhysicalComponentDefinition definition = command.getDefinition();
            Component component = this.build(definition);
            URI classLoaderId = definition.getClassLoaderId();
            component.setClassLoaderId(classLoaderId);
            this.componentManager.register(component);
        }
        catch (BuilderException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (RegistrationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public Component build(PhysicalComponentDefinition definition) throws BuilderException {
        ComponentBuilder builder = this.builders.get(definition.getClass());
        if (builder == null) {
            throw new BuilderNotFoundException("Builder not found for " + definition.getClass().getName());
        }
        return builder.build(definition);
    }
}

