/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.List;
import org.fabric3.fabric.command.DisposeChannelsCommand;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.RegistrationException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DisposeChannelsCommandExecutor
implements CommandExecutor<DisposeChannelsCommand> {
    private ChannelManager channelManager;
    private CommandExecutorRegistry executorRegistry;

    @Constructor
    public DisposeChannelsCommandExecutor(@Reference ChannelManager channelManager, @Reference CommandExecutorRegistry executorRegistry) {
        this.channelManager = channelManager;
        this.executorRegistry = executorRegistry;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DisposeChannelsCommand.class, (CommandExecutor)this);
    }

    public void execute(DisposeChannelsCommand command) throws ExecutionException {
        try {
            List<PhysicalChannelDefinition> definitions = command.getDefinitions();
            for (PhysicalChannelDefinition definition : definitions) {
                URI uri = definition.getUri();
                this.channelManager.unregister(uri);
            }
        }
        catch (RegistrationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

