/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.fabric3.fabric.command.StartContextCommand;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.WorkContext;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class StartContextCommandExecutor
implements CommandExecutor<StartContextCommand> {
    private ScopeContainer compositeScopeContainer;
    private ScopeContainer domainScopeContainer;
    private CommandExecutorRegistry commandExecutorRegistry;

    @Constructor
    public StartContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry) {
        this.commandExecutorRegistry = executorRegistry;
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
    }

    public StartContextCommandExecutor(ScopeRegistry scopeRegistry) {
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(StartContextCommand.class, (CommandExecutor)this);
    }

    public void execute(StartContextCommand command) throws ExecutionException {
        QName deployable = command.getDeployable();
        WorkContext workContext = new WorkContext();
        CallFrame frame = new CallFrame((Serializable)deployable);
        workContext.addCallFrame(frame);
        try {
            this.compositeScopeContainer.startContext(workContext);
            if (this.domainScopeContainer != null) {
                this.domainScopeContainer.startContext(workContext);
            }
        }
        catch (ComponentException e) {
            throw new ExecutionException("Error executing command", (Throwable)e);
        }
    }
}

