/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.command.UnProvisionExtensionsCommand;
import org.fabric3.fabric.executor.ProvisionedExtensionTracker;
import org.fabric3.host.contribution.ContributionNotFoundException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.contribution.RemoveException;
import org.fabric3.host.contribution.UninstallException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class UnProvisionExtensionsCommandExecutor
implements CommandExecutor<UnProvisionExtensionsCommand> {
    private Domain domain;
    private CommandExecutorRegistry commandExecutorRegistry;
    private ContributionService contributionService;
    private ContributionResolver resolver;
    private ProvisionedExtensionTracker tracker;

    public UnProvisionExtensionsCommandExecutor(@Reference(name="domain") Domain domain, @Reference CommandExecutorRegistry commandExecutorRegistry, @Reference ContributionService contributionService, @Reference ContributionResolver resolver, @Reference ProvisionedExtensionTracker tracker) {
        this.commandExecutorRegistry = commandExecutorRegistry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.resolver = resolver;
        this.tracker = tracker;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(UnProvisionExtensionsCommand.class, (CommandExecutor)this);
    }

    public synchronized void execute(UnProvisionExtensionsCommand command) throws ExecutionException {
        ArrayList<URI> uninstall = new ArrayList<URI>();
        for (URI uri : command.getExtensionUris()) {
            int count = this.tracker.decrement(uri);
            if (count != 0) continue;
            try {
                List deployables = this.contributionService.getDeployables(uri);
                ArrayList reverse = new ArrayList(deployables);
                Collections.reverse(reverse);
                for (Deployable deployable : reverse) {
                    QName name = deployable.getName();
                    this.domain.undeploy(name);
                }
                uninstall.add(uri);
            }
            catch (DeploymentException e) {
                throw new ExecutionException((Throwable)e);
            }
            catch (ContributionNotFoundException e) {
                throw new ExecutionException((Throwable)e);
            }
            try {
                this.resolver.release(uri);
            }
            catch (ResolutionException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        try {
            this.contributionService.uninstall(uninstall);
            this.contributionService.remove(uninstall);
        }
        catch (ContributionNotFoundException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (RemoveException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (UninstallException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

