/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.expression;

import java.util.Map;
import java.util.TreeMap;
import org.fabric3.fabric.expression.ValueNotFoundException;
import org.fabric3.spi.expression.ExpressionEvaluator;
import org.fabric3.spi.expression.ExpressionExpander;
import org.fabric3.spi.expression.ExpressionExpansionException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionExpanderImpl
implements ExpressionExpander {
    private static final String PREFIX = "${";
    private static final String POSTFIX = "}";
    private TreeMap<Integer, ExpressionEvaluator> evaluators = new TreeMap();

    @Reference
    public void setEvaluators(Map<Integer, ExpressionEvaluator> evaluators) {
        this.evaluators.putAll(evaluators);
    }

    public String expand(String value) throws ExpressionExpansionException {
        StringBuilder builder = new StringBuilder();
        this.expand(value, 0, builder);
        return builder.toString();
    }

    private StringBuilder expand(String value, int index, StringBuilder builder) throws ExpressionExpansionException {
        String expression;
        String evaluated;
        int start = value.indexOf(PREFIX, index);
        if (start == -1) {
            return builder.append(value.substring(index));
        }
        int end = value.indexOf(POSTFIX, index + 2);
        if (end == -1) {
            throw new ExpressionExpansionException("No closing } for expression starting at " + start + " in :" + value);
        }
        if (index != start) {
            builder.append(value.substring(index, start));
        }
        if ((evaluated = this.evaluate(expression = value.substring(start + 2, end))) == null) {
            throw new ValueNotFoundException("Value not defined for '" + expression + "' in: " + value);
        }
        builder.append(evaluated);
        if (end < value.length() - 1) {
            this.expand(value, end + 1, builder);
        }
        return builder;
    }

    private String evaluate(String expression) {
        for (ExpressionEvaluator evaluator : this.evaluators.values()) {
            String expanded = evaluator.evaluate(expression);
            if (expanded == null) continue;
            return expanded;
        }
        return null;
    }
}

