/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.command.AttachChannelConnectionCommand;
import org.fabric3.fabric.command.ChannelConnectionCommand;
import org.fabric3.fabric.command.DetachChannelConnectionCommand;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.osoa.sca.annotations.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class AbstractChannelCommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public AbstractChannelCommandGenerator(GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    protected void generateDefinitions(LogicalChannel channel, ChannelConnectionCommand connectionCommand, boolean incremental) throws GenerationException {
        for (LogicalBinding binding : channel.getBindings()) {
            Object attachCommand;
            ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
            PhysicalConnectionSourceDefinition source = bindingGenerator.generateConnectionSource(binding);
            ChannelTargetDefinition target = new ChannelTargetDefinition(channel.getUri());
            URI classLoaderUri = channel.getDefinition().getContributionUri();
            source.setClassLoaderId(classLoaderUri);
            target.setClassLoaderId(classLoaderUri);
            List<PhysicalEventStreamDefinition> streams = this.generateStreams();
            PhysicalChannelConnectionDefinition definition = new PhysicalChannelConnectionDefinition(source, (PhysicalConnectionTargetDefinition)target, streams);
            if (LogicalState.NEW == channel.getState() || !incremental || LogicalState.NEW == binding.getState()) {
                attachCommand = new AttachChannelConnectionCommand(definition);
                connectionCommand.add((AttachChannelConnectionCommand)attachCommand);
                continue;
            }
            if (LogicalState.MARKED != channel.getState() && incremental && LogicalState.MARKED != binding.getState()) continue;
            attachCommand = new DetachChannelConnectionCommand(definition);
            connectionCommand.add((DetachChannelConnectionCommand)attachCommand);
        }
    }

    private List<PhysicalEventStreamDefinition> generateStreams() {
        ArrayList<PhysicalEventStreamDefinition> streams = new ArrayList<PhysicalEventStreamDefinition>();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition("default");
        definition.addEventType(Object.class.getName());
        streams.add(definition);
        return streams;
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

