/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import org.fabric3.fabric.command.ChannelConnectionCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.channel.AbstractChannelCommandGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BoundChannelCommandGenerator
extends AbstractChannelCommandGenerator
implements CommandGenerator {
    private int order;

    public BoundChannelCommandGenerator(@Reference GeneratorRegistry generatorRegistry, @Property(name="order") int order) {
        super(generatorRegistry);
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ChannelConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent)) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        ChannelConnectionCommand connectionCommand = new ChannelConnectionCommand();
        for (LogicalChannel channel : composite.getChannels()) {
            if (!channel.isConcreteBound()) continue;
            this.generateDefinitions(channel, connectionCommand, incremental);
        }
        if (connectionCommand.getAttachCommands().isEmpty() && connectionCommand.getDetachCommands().isEmpty()) {
            return null;
        }
        return connectionCommand;
    }
}

