/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.channel.ChannelIntents;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BuildChannelCommandGenerator
implements CommandGenerator {
    private int order;

    public BuildChannelCommandGenerator(@Property(name="order") int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public CompensatableCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent)) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        List<PhysicalChannelDefinition> definitions = this.createDefinitions(composite, incremental);
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildChannelsCommand(definitions);
    }

    private List<PhysicalChannelDefinition> createDefinitions(LogicalCompositeComponent composite, boolean incremental) {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        for (LogicalChannel channel : composite.getChannels()) {
            if (channel.getState() != LogicalState.NEW && incremental) continue;
            boolean sync = channel.getDefinition().getIntents().contains(ChannelIntents.SYNC_INTENT);
            PhysicalChannelDefinition definition = new PhysicalChannelDefinition(channel.getUri(), channel.getDeployable(), sync);
            definitions.add(definition);
        }
        return definitions;
    }
}

