/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.channel.ConnectionGenerator;
import org.fabric3.fabric.model.physical.ChannelSourceDefinition;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.fabric.model.physical.TypeEventFilterDefinition;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.spi.generator.ComponentGenerator;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.model.type.java.JavaType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGeneratorImpl
implements ConnectionGenerator {
    private GeneratorRegistry generatorRegistry;

    public ConnectionGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public List<PhysicalChannelConnectionDefinition> generateProducer(LogicalProducer producer) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)producer.getParent();
        ComponentGenerator<LogicalComponent> componentGenerator = this.getGenerator(component);
        PhysicalConnectionSourceDefinition sourceDefinition = componentGenerator.generateConnectionSource(producer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        sourceDefinition.setClassLoaderId(classLoaderId);
        ArrayList<PhysicalEventStreamDefinition> eventStreams = new ArrayList<PhysicalEventStreamDefinition>();
        for (LogicalOperation operation : producer.getOperations()) {
            eventStreams.add(this.generate(operation));
        }
        if (producer.isConcreteBound()) {
            for (LogicalBinding binding : producer.getBindings()) {
                ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
                PhysicalConnectionTargetDefinition targetDefinition = bindingGenerator.generateConnectionTarget(binding);
                targetDefinition.setClassLoaderId(classLoaderId);
                PhysicalChannelConnectionDefinition connectionDefinition = new PhysicalChannelConnectionDefinition(sourceDefinition, targetDefinition, eventStreams);
                definitions.add(connectionDefinition);
            }
        } else {
            for (URI uri : producer.getTargets()) {
                ChannelTargetDefinition targetDefinition = new ChannelTargetDefinition(uri);
                targetDefinition.setClassLoaderId(classLoaderId);
                PhysicalChannelConnectionDefinition connectionDefinition = new PhysicalChannelConnectionDefinition(sourceDefinition, (PhysicalConnectionTargetDefinition)targetDefinition, eventStreams);
                definitions.add(connectionDefinition);
            }
        }
        return definitions;
    }

    @Override
    public List<PhysicalChannelConnectionDefinition> generateConsumer(LogicalConsumer consumer) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        ComponentGenerator<LogicalComponent> generator = this.getGenerator(component);
        PhysicalConnectionTargetDefinition targetDefinition = generator.generateConnectionTarget(consumer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        targetDefinition.setClassLoaderId(classLoaderId);
        List<PhysicalEventStreamDefinition> eventStreams = this.generate(consumer);
        if (consumer.isConcreteBound()) {
            for (LogicalBinding binding : consumer.getBindings()) {
                ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
                PhysicalConnectionSourceDefinition sourceDefinition = bindingGenerator.generateConnectionSource(binding);
                sourceDefinition.setClassLoaderId(classLoaderId);
                PhysicalChannelConnectionDefinition connectionDefinition = new PhysicalChannelConnectionDefinition(sourceDefinition, targetDefinition, eventStreams);
                definitions.add(connectionDefinition);
            }
        } else {
            for (URI uri : consumer.getSources()) {
                ChannelSourceDefinition sourceDefinition = new ChannelSourceDefinition(uri);
                sourceDefinition.setClassLoaderId(classLoaderId);
                PhysicalChannelConnectionDefinition connectionDefinition = new PhysicalChannelConnectionDefinition((PhysicalConnectionSourceDefinition)sourceDefinition, targetDefinition, eventStreams);
                definitions.add(connectionDefinition);
            }
        }
        return definitions;
    }

    private PhysicalEventStreamDefinition generate(LogicalOperation operation) {
        Operation o = operation.getDefinition();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition(o.getName());
        definition.setName(o.getName());
        List params = o.getInputTypes();
        for (DataType param : params) {
            Class paramType = param.getPhysical();
            String paramName = paramType.getName();
            definition.addEventType(paramName);
        }
        return definition;
    }

    private List<PhysicalEventStreamDefinition> generate(LogicalConsumer consumer) {
        ArrayList<PhysicalEventStreamDefinition> streams = new ArrayList<PhysicalEventStreamDefinition>();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition("default");
        List types = consumer.getDefinition().getTypes();
        boolean typed = false;
        for (DataType dataType : types) {
            if (dataType instanceof JavaType && !Object.class.equals(dataType.getLogical())) {
                typed = true;
            }
            definition.addEventType(dataType.getPhysical().getName());
        }
        if (typed) {
            TypeEventFilterDefinition typeFilter = new TypeEventFilterDefinition(types);
            definition.addFilterDefinition((PhysicalEventFilterDefinition)typeFilter);
        }
        streams.add(definition);
        return streams;
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) throws GeneratorNotFoundException {
        Implementation implementation = component.getDefinition().getImplementation();
        return this.generatorRegistry.getComponentGenerator(implementation.getClass());
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

