/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.fabric.command.ChannelConnectionCommand;
import org.fabric3.fabric.command.DisposeChannelsCommand;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.channel.AbstractChannelCommandGenerator;
import org.fabric3.fabric.generator.channel.ChannelIntents;
import org.fabric3.fabric.generator.channel.DomainChannelCommandGenerator;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DomainChannelCommandGeneratorImpl
extends AbstractChannelCommandGenerator
implements DomainChannelCommandGenerator {
    public DomainChannelCommandGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        super(generatorRegistry);
    }

    @Override
    public CompensatableCommand generateBuild(LogicalChannel channel, boolean incremental) throws GenerationException {
        List<PhysicalChannelDefinition> definitions = this.createBuildDefinitions(channel, incremental);
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildChannelsCommand(definitions);
    }

    @Override
    public CompensatableCommand generateDispose(LogicalChannel channel, boolean incremental) throws GenerationException {
        List<PhysicalChannelDefinition> definitions = this.createDisposeDefinitions(channel);
        if (definitions.isEmpty()) {
            return null;
        }
        return new DisposeChannelsCommand(definitions);
    }

    @Override
    public ChannelConnectionCommand generateAttachDetach(LogicalChannel channel, boolean incremental) throws GenerationException {
        if (!channel.isConcreteBound()) {
            return null;
        }
        ChannelConnectionCommand connectionCommand = new ChannelConnectionCommand();
        this.generateDefinitions(channel, connectionCommand, incremental);
        if (connectionCommand.getAttachCommands().isEmpty() && connectionCommand.getDetachCommands().isEmpty()) {
            return null;
        }
        return connectionCommand;
    }

    private List<PhysicalChannelDefinition> createBuildDefinitions(LogicalChannel channel, boolean incremental) {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        if (channel.getState() == LogicalState.NEW || !incremental) {
            this.generateChannelDefinition(channel, definitions);
        }
        return definitions;
    }

    private List<PhysicalChannelDefinition> createDisposeDefinitions(LogicalChannel channel) {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        if (channel.getState() == LogicalState.MARKED) {
            this.generateChannelDefinition(channel, definitions);
        }
        return definitions;
    }

    private void generateChannelDefinition(LogicalChannel channel, List<PhysicalChannelDefinition> definitions) {
        boolean sync = channel.getDefinition().getIntents().contains(ChannelIntents.SYNC_INTENT);
        PhysicalChannelDefinition definition = new PhysicalChannelDefinition(channel.getUri(), channel.getDeployable(), sync);
        definitions.add(definition);
    }
}

