/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.collator;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.generator.GenerationType;
import org.fabric3.fabric.generator.collator.ContributionCollator;
import org.fabric3.host.Names;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionCollatorImpl
implements ContributionCollator {
    private MetaDataStore store;

    public ContributionCollatorImpl(@Reference MetaDataStore store) {
        this.store = store;
    }

    @Override
    public Map<String, List<Contribution>> collateContributions(List<LogicalComponent<?>> components, GenerationType type) {
        HashMap<String, List<Contribution>> contributionsPerZone = new HashMap<String, List<Contribution>>();
        for (LogicalComponent<?> component : components) {
            if (type != GenerationType.FULL && (GenerationType.INCREMENTAL == type && LogicalState.NEW != component.getState() || GenerationType.UNDEPLOY == type && LogicalState.MARKED != component.getState())) continue;
            URI contributionUri = component.getDefinition().getContributionUri();
            String zone = component.getZone();
            ArrayList<Contribution> contributions = (ArrayList<Contribution>)contributionsPerZone.get(zone);
            if (contributions == null) {
                contributions = new ArrayList<Contribution>();
                contributionsPerZone.put(zone, contributions);
            }
            Contribution contribution = this.store.find(contributionUri);
            List contributionWires = contribution.getWires();
            for (ContributionWire wire : contributionWires) {
                URI importedUri = wire.getExportContributionUri();
                Contribution imported = this.store.find(importedUri);
                if (contributions.contains(imported) || Names.HOST_CONTRIBUTION.equals(importedUri) || Names.BOOT_CONTRIBUTION.equals(importedUri)) continue;
                contributions.add(imported);
            }
            if (contributions.contains(contribution)) continue;
            contributions.add(contribution);
        }
        return contributionsPerZone;
    }
}

