/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.command.StartContextCommand;
import org.fabric3.fabric.generator.context.StartContextCommandGenerator;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.osoa.sca.annotations.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class StartContextCommandGeneratorImpl
implements StartContextCommandGenerator {
    @Override
    public Map<String, List<CompensatableCommand>> generate(List<LogicalComponent<?>> components, boolean incremental) throws GenerationException {
        HashMap<String, List<CompensatableCommand>> commands = new HashMap<String, List<CompensatableCommand>>();
        for (LogicalComponent<?> component : components) {
            if (component.getState() != LogicalState.NEW && incremental) continue;
            StartContextCommand command = new StartContextCommand(component.getDeployable());
            String zone = component.getZone();
            List<CompensatableCommand> list = this.getCommands(zone, commands);
            if (list.contains(command)) continue;
            list.add(command);
        }
        return commands;
    }

    private List<CompensatableCommand> getCommands(String zone, Map<String, List<CompensatableCommand>> startCommands) {
        List<CompensatableCommand> list = startCommands.get(zone);
        if (list == null) {
            list = new ArrayList<CompensatableCommand>();
            startCommands.put(zone, list);
        }
        return list;
    }
}

